% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getProduct.R
\name{getProduct}
\alias{getProduct}
\title{Check and Create Product-Related Information}
\usage{
getProduct(x = NULL, quiet = FALSE, ...)
}
\arguments{
\item{x}{\code{character}. MODIS file name, product name, regular expression
passed as pattern to \code{\link[=grep]{grep()}}, or missing. Use dot notation to address
Terra and Aqua products at the same time, e.g. \code{"M.D13Q1"}.}

\item{quiet}{\code{logical}, defaults to \code{FALSE}.}

\item{...}{Additional arguments passed to \code{\link[=getCollection]{getCollection()}}.}
}
\value{
If 'x' is missing, a \code{data.frame} with information about all MODIS products
available. In case of \code{character} input, an invisible \linkS4class{MODISproduct} or
\linkS4class{MODISfile} object depending on the type of input (product, regular
expression or file name); the object holds information usable by other
functions.
}
\description{
On user side, it is a function to find the desired product. On package site,
it generates central internal information to handle files.
}
\examples{
getProduct() # list available products

# or use regular expression style
getProduct("M.D11C3")
getProduct("M*D11C")

# or get information about specific product
internal_info <- getProduct("MOD11C3", quiet = TRUE) 
internal_info

# or use a valid filename
fileinfo <- getProduct("MYD11A1.A2009001.h18v04.006.2015363221538.hdf")
fileinfo

}
\author{
Matteo Mattiuzzi and Florian Detsch
}
