% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_info.R
\name{get_info}
\alias{get_info}
\title{Collect Model Equations and Data per Tree}
\usage{
get_info(model, dataset, data, id = NULL, condition = NULL,
  include_data = FALSE, core = NULL, autosave = TRUE)
}
\arguments{
\item{model}{A model definition, typically the path to an \code{.eqn} model
file containing the model equations. Category names need to match column
names in \code{data}.}

\item{dataset}{scalar \code{character} vector. Name of the data set that will
be copied to the results \code{tibble}.}

\item{data}{A \code{data.frame} containing the data. Column
names need to match category names in \code{model} (i.e., different from
\pkg{MPTinR} behavior, order of categories is not important, matching is
done via name).}

\item{id}{scalar \code{character} vector. Name of the column that contains
the subject identifier. If not specified, it is assumed that each row
represents observations from one participant.}

\item{condition}{scalar \code{character} vector. Name of the column
specifying a between-subjects factor. If not specified, no between-subjects
comparisons are performed.}

\item{include_data}{If \code{FALSE} (the default) the response frequencies
are not part of the output, but only the number of observations per tree.
If \code{TRUE}, the full data is part of the output.}

\item{core}{\code{character} vector defining the core parameters of interest,
e.g., \code{core = c("Dn", "Do")}. All other parameters are treated as
auxiliary parameters.}

\item{autosave}{If \code{TRUE} (the default) the results are automatically
saved in the current working directory in a file with name derived from
both model and data.}
}
\value{
A list. If \code{autosave = TRUE}, the list is also saved in the
  current working directory.
}
\description{
Helper function that collects model equation and data per tree
  for further analysis.
}
