% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mqmf_utils.r
\name{linter}
\alias{linter}
\title{linter finds a value in a series using its location in another}
\usage{
linter(pars)
}
\arguments{
\item{pars}{a vector of 5 values, left, right, bottom, top and target}
}
\value{
a single value being the x-axis value between left and right
    corresponding to the target on the x-axis
}
\description{
linter is a tool for linearly interpolating in a 2-D
    cartesian space to search out an unknown value between two known
    points on the x-axis, based on a known value between two known 
    points on the y-axis. This might be answering the question of
    what would be the length at 50 percent maturity for a curve with no 
    analytical solution. We could find two points in a series of
    proportion values on the y-axis that bracketed the 50 percent value 
    using the function bracket. They would be associated with the two 
    length values on the x-axis used to generate the predicted 
    proportion values. If we assume the various points in the 2-D 
    space to be approximated by linear relations then the location 
    between the two known x-axis length values corresponding to the 
    L50 would have the same ratio as the 50 percent value has to the two
    points on the y-axis. See the example for details. The input
    arguments include five values, left, right, bottom, top, and 
    target. So, left and right are sequential values on the x-axis, 
    bottom and top are the corresponding sequential values on the 
    y-axis, and target is the value we are looking for on the y-axis.
}
\examples{
 L = seq(60,160,1)
 p=c(a=0.075,b=0.075,c=1.0,alpha=100)
 asym <- srug(p=p,sizeage=L)
 L25 <- linter(bracket(0.25,asym,L)) 
 L50 <- linter(bracket(0.5,asym,L)) 
 L75 <- linter(bracket(0.75,asym,L)) 
 ans <- c(L25,L50,L75,L50-L25,L75-L50)
 {cat("   L25    L50      L75   L50-L25 L75-L50 \n")
 cat(round(ans,4),"\n")} 
}
\seealso{
bracket
}
