% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.r
\docType{data}
\name{schaef}
\alias{schaef}
\title{schaef is yellowfin tuna fishery data from Schaefer 1957}
\format{
A data.frame of fisheries data
\describe{
  \item{year}{the fishing year from 1934 - 1955}
  \item{catch}{the total annual catch, '000s of pounds }
  \item{effort}{the total effort as standard class 4 clipper fishing days}
  \item{cpue}{the catch '000 pounds per standard class 4 day, a ratio cpue}
}
}
\source{
from Table 1 page 266 in Schaefer, M.B. (1957) A study of the dynamics of the 
    fishery for yellowfin tuna in the Eastern Tropical Pacific Ocean. 
    Bulletin, Inter-American Tropical Tuna Commission 2: 247-285. Obtainable from
    \emph{https://www.iattc.org/BulletinsENG.htm}
}
\description{
schaef is yellowfin tuna fishery data from Schaefer
    (1957) It contains the year, the catch, the effort, and the cpue 
    and was used in one of the first descriptions of a stock 
    assessment that used a surplus production model. The catch-per-
    unit-effort, cpue, is a ratio cpue of the total catch divided by 
    the total effort as thousands of pounds per day. These days such 
    ratios tend not to be used, with individual records 
    for each day's effort being used instead. Using individual records 
    does not obscure the variation between different 
    vessels, areas, depths, and seasons. Initial parameter estimates 
    close to the optimum values for both the Schaefer model and the
    Fox model could be
    param <- log(c(r=0.24,K=2100000,Binit=2200000,sigma=0.2))
}
\section{Subjects}{

 \itemize{
   \item surplus production modelling
   \item classical fisheries data
   \item Log-Normal likelihoods
 }
}

\examples{
 data(schaef)
 pars <- log(c(r=0.2,K=2.1e06,Binit=2.2e06,sigma=0.2))
 answer <- fitSPM(pars,schaef,schaefer=TRUE,maxiter=1000)
 outfit(answer,title="Schaefer, 1957 Data",digits=4)
}
