% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrt_binary_ss.R
\name{mrt_binary_ss}
\alias{mrt_binary_ss}
\title{Calculate sample size for binary outcome MRT}
\usage{
mrt_binary_ss(
  avail_pattern,
  f_t,
  g_t,
  beta,
  alpha,
  p_t,
  gamma,
  b,
  exact = FALSE,
  less_than_10_possible = FALSE
)
}
\arguments{
\item{avail_pattern}{A vector of length m that is the average availability at
each time point}

\item{f_t}{Defines marginal excursion effect MEE(t) under
alternative together with beta. Assumed to be matrix of size m*p.}

\item{g_t}{Defines success probability null curve together with
alpha. Assumed to be matrix of size m*q.}

\item{beta}{Length p vector that defines marginal excursion effect
MEE(t) under alternative together with f_t.}

\item{alpha}{Length q vector that defines success probability null
curve together with g_t.}

\item{p_t}{Length m vector of Randomization probabilities at each
time point.}

\item{gamma}{Desired Type I error}

\item{b}{Desired Type II error}

\item{exact}{Determines if exact n or ceiling will be returned}

\item{less_than_10_possible}{If TRUE, returns sample size (instead of error)
even if the calculated sample size is <= 10. Setting to TRUE is not recommended. 
Defaults to FALSE.}
}
\value{
Sample size to achieve desired power.
}
\description{
Returns sample size needed to achieve a specified power for the hypothesis test
of marginal excursion effect (see Details) in the context of an MRT with binary outcomes
with small sample correction using F-distribution. See the vignette for
more details.
}
\details{
When the calculator finds out that a sample size less than
or equal to 10 is sufficient to attain the desired power, the calculator does
not output the exact sample size but produces an error message. This is because 
the sample size calculator is based on an asymptotic result, and in
this situation the sample size result may not be as accurate.
(A small sample correction is built in the calculator, but even with the correction
the sample size result may still be inaccurate when it is <= 10.) In general,
when the output sample size is small, one might reconsider the following: (1)
whether you are correctly or conservatively guessing the average of expected
availability, (2) whether the duration of study is too long, (3) whether the
treatment effect is overestimated, and (4) whether the power is set too low.
}
\examples{
mrt_binary_ss(tau_t_1, f_t_1, g_t_1, 
                                         beta_1, alpha_1, p_t_1, 
                                         0.05, .2, FALSE)
}
