% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_MPs.R
\name{Data-rich-MP}
\alias{Data-rich-MP}
\alias{MP}
\alias{SCA_MSY}
\alias{SCA_75MSY}
\alias{SCA_4010}
\alias{DDSS_MSY}
\alias{DDSS_75MSY}
\alias{DDSS_4010}
\alias{SP_MSY}
\alias{SP_75MSY}
\alias{SP_4010}
\title{Data-rich management procedures}
\usage{
SCA_MSY(x, Data, reps = 1)

SCA_75MSY(x, Data, reps = 1)

SCA_4010(x, Data, reps = 1)

DDSS_MSY(x, Data, reps = 1)

DDSS_75MSY(x, Data, reps = 1)

DDSS_4010(x, Data, reps = 1)

SP_MSY(x, Data, reps = 1)

SP_75MSY(x, Data, reps = 1)

SP_4010(x, Data, reps = 1)
}
\arguments{
\item{x}{A position in the Data object.}

\item{Data}{An object of class Data}

\item{reps}{Numeric, the number of stochastic replicates for the management advice.}
}
\value{
An object of class Rec which contains the management recommendation.
}
\description{
A suite of data-rich management procedures (MPs) included in the package. Additional MPs,
with specific model configurations (e.g., stock-recruit function or fixing certain parameters) or alternative
ramped harvest control rules can be created with \link{make_MP} and the available Assess and HCR objects.
}
\section{Functions}{
\itemize{
\item \code{SCA_MSY}: A statistical catch-at-age model with a TAC recommendation based on fishing at UMSY,
and default arguments for configuring \link{SCA}.

\item \code{SCA_75MSY}: An SCA with a TAC recommendation based on fishing at 75\% of UMSY.

\item \code{SCA_4010}: An SCA with a 40-10 control rule.

\item \code{DDSS_MSY}: A state-space delay difference model with a TAC recommendation based on fishing at UMSY,
and default arguments for configuring \link{DD_SS}.

\item \code{DDSS_75MSY}: A state-space delay difference model with a TAC recommendation based on fishing at 75\% of UMSY.

\item \code{DDSS_4010}: A state-space delay difference model with a 40-10 control rule.

\item \code{SP_MSY}: A surplus production model with a TAC recommendation based on fishing at UMSY,
and default arguments for configuring \link{SP}.

\item \code{SP_75MSY}: A surplus production model with a TAC recommendation based on fishing at 75\% of UMSY.

\item \code{SP_4010}: A surplus production model with a 40-10 control rule.
}}

\examples{
avail("MP", all_avail = FALSE)

\dontrun{
myMSE <- DLMtool::runMSE(DLMtool::testOM, MPs = c("FMSYref", "SCA_MSY", "SCA_4010"))
}
}
