% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OM_functions.R
\name{LH2OM}
\alias{LH2OM}
\alias{predictLH}
\title{Predict missing life-history parameters}
\source{
\url{https://github.com/James-Thorson-NOAA/FishLife}
}
\usage{
LH2OM(
  OM,
  dist = c("unif", "norm"),
  filterMK = FALSE,
  plot = TRUE,
  Class = "predictive",
  Order = "predictive",
  Family = "predictive",
  msg = TRUE,
  db = MSEtool::LHdatabase
)

predictLH(
  inpars = list(),
  Genus = "predictive",
  Species = "predictive",
  nsamp = 100,
  db = MSEtool::LHdatabase,
  dist = c("unif", "norm"),
  filterMK = TRUE,
  plot = TRUE,
  Class = "predictive",
  Order = "predictive",
  Family = "predictive",
  msg = TRUE
)
}
\arguments{
\item{OM}{An object of class 'OM'}

\item{dist}{Character. Should parameters be sampled from a uniform (\code{unif}) or
normal (\code{norm}) distribution?}

\item{filterMK}{Logical. Should the predicted M and K parameters be filtered within the range specified in \code{inpars}or \code{OM}?
e.g. \code{OM@M} and \code{OM@K}. Empty slots or slots with all values of 0 are considered unknown.}

\item{plot}{Logical. Should the plot be produced?}

\item{Class}{Optional higher order taxonomic information}

\item{Order}{Optional higher order taxonomic information}

\item{Family}{Optional higher order taxonomic information}

\item{msg}{Logical. Should messages be printed?}

\item{db}{Database from FishLife model with fitted model results}

\item{inpars}{A named list with lower and upper bounds of provided parameters: \emph{Linf}, \emph{L50},
\emph{K} and \emph{M} (must be length 2). Unknown or missing parameters should not be included. For example, an empty list assumes
that all four life history parameters are unknown and need to be estimated. See Details below for more information.}

\item{Genus}{Character string specifying the Genus name. Optional. Default is 'predictive'}

\item{Species}{Character string specifying the Species name. Optional. Default is 'predictive'. If full species name
(Genus + Species) is not found if FishLife database (based on FishBase) higher order taxonomy will be used (e.g., Family)
for the predictions.}

\item{nsamp}{The number of samples to return}
}
\value{
LH2OM: An OM with \code{OM@cpars} populated with \code{OM@nsim} samples of M, K, Linf and L50

predictLH: A data.frame with \code{nsamp} rows with \code{Linf}, \code{L50}, \code{K}, and \code{M} values.
}
\description{
Predict missing life-history based on taxonomic information and
hierarchical model fitted to FishBase life-history parameters
}
\details{
The model predicts missing life-history parameters based on provided parameters and taxonomic information.
If both \emph{M} and \emph{K} are provided in \code{inpars} or  \code{OM}, \emph{K} values are predicted and predictions filtered
so that resulting \emph{K} values are within bounds specified in \code{inpars$K} or \code{OM@K} (see \code{filterMK}).

If both \emph{Linf} and \emph{L50} are provided in \code{inpars} or \code{OM}, \emph{L50} values are predicted and values in \code{inpars$L50}
or \code{OM@L50} are ignored.
}
\section{Functions}{
\itemize{
\item \code{LH2OM}: Predict missing life-history and populate \code{OM@cpars}

\item \code{predictLH}: Predict missing life-history based on taxonomic information and
hierarchical model fitted to FishBase life-history parameters
}}

\references{
Thorson, J. T., S. B. Munch, J. M. Cope, and J. Gao. 2017.
Predicting life history parameters for all fishes worldwide. Ecological Applications. 27(8): 2262--2276
}
\author{
A. Hordyk
}
