% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OM_import.R
\name{XL2OM}
\alias{XL2OM}
\title{Load OM from Excel file}
\usage{
XL2OM(name = NULL, cpars = NULL, msg = TRUE)
}
\arguments{
\item{name}{Name of the OM Excel file. Provide full file path if not in current directory.}

\item{cpars}{An optional list of custom parameters (single parameters are a vector nsim
long, time series are a matrix nsim rows by nyears columns)}

\item{msg}{Should messages be printed?}
}
\value{
An object of class OM
}
\description{
Imports an OM from a correctly formatted Excel file. Create the Excel spreadsheet template
using \code{OMinit} and document each slot in the corresponding text file.
}
\details{
An error message will alert if any slots are missing values, or if the Excel file is missing
the required tabs.
}
\examples{
\dontrun{
OMinit('myOM', templates=list(Stock='Herring', Fleet='Generic_Fleet', Obs='Generic_Obs',
Imp='Perfect_Imp'), overwrite=TRUE)
myOM <- XL2OM('myOM.xlsx')

}
}
\author{
A. Hordyk
}
