\docType{data}
\name{t.diff}
\alias{t.diff}
\title{The differences of P-values in t test assuming equal or unequal
variances}
\format{A data frame with 1000 rows and 99 columns.}
\source{
  By simulation.
}
\description{
  Given that the variances of two groups are unequal, we
  compute the difference of P-values assuming equal or
  unequal variances respectively by simulation.
}
\details{
  See the Examples section for the generation of this data.
}
\examples{
data(t.diff)
boxplot(t.diff, axes = FALSE, xlab = expression(n[1]))
axis(1)
axis(2)
box()

## reproducing the data
if (interactive()) {
    set.seed(123)
    t.diff = NULL
    for (n1 in 2:100) {
        t.diff = rbind(t.diff, replicate(1000, {
            x1 = rnorm(n1, mean = 0, sd = runif(1, 0.5, 1))
            x2 = rnorm(30, mean = 1, sd = runif(1, 2, 5))
            t.test(x1, x2, var.equal = TRUE)$p.value - t.test(x1, 
                x2, var.equal = FALSE)$p.value
        }))
    }
    t.diff = as.data.frame(t(t.diff))
    colnames(t.diff) = 2:100
}
}
\references{
  Welch B (1947). ``The generalization of Student's problem
  when several different population variances are
  involved.'' Biometrika, 34(1/2), 28--35.
}
\keyword{datasets}
