% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_CHPTest.R
\name{CHPTest}
\alias{CHPTest}
\title{Carrasco, Hu, and Ploberger (2014) parameter stability test}
\usage{
CHPTest(Y, p, control = list())
}
\arguments{
\item{Y}{A (\code{T x 1}) matrix of observations.}

\item{p}{Integer determining the number of autoregressive lags.}

\item{control}{List with test procedure options including: 
\itemize{
  \item{\code{N}: }{Integer determining the number of Bootstrap iterations. Default is set to \code{3000} as in paper.}
  \item{\code{rho_b}: }{Number determining bounds for distribution of \code{rh0} (i.e. \code{rho} ~ \code{[-rho_b,rho_b]}).}
  \item{\code{msvar}: }{Boolean indicator. If \code{TRUE}, there is a switch in variance. If \code{FALSE} only switch in mean is considered.}
  \item{\code{getSE}: }{Boolean indicator. If \code{TRUE}, standard errors for restricted model are estimated. If \code{FALSE} no standard errors are estimated. Default is \code{TRUE}.}
}}
}
\value{
List of class \code{CHPTest} (\code{S3} object) with model attributes including: 
\itemize{
  \item{\code{mdl_h0}: }{List with restricted model attributes. This will be of class \code{ARmdl} (\code{S3} object). See \code{\link{ARmdl}}.}
  \item{\code{supTS}: }{supTS test statistic value.}
  \item{\code{expTS}: }{expTS test statistic value.}
  \item{\code{supTS_N}: }{A (\code{N x 1}) vector with simulated supTS test statistics under null hypothesis.}
  \item{\code{expTS_N}: }{A (\code{N x 1}) vector with simulated expTS test statistics under null hypothesis.}
  \item{\code{pval_supTS}: }{P-value for supTS version of parameter stability test.}
  \item{\code{pval_expTS}: }{P-value for expTS version of parameter stability test.}
  \item{\code{supTS_cv}: }{Vector with 90\%, 95\%, and 99\% bootstrap critical values for supTS version of parameter stability test.}
  \item{\code{expTS_cv}: }{Vector with 90\%, 95\%, and 99\% bootstrap critical values for expTS version of parameter stability test.}
  \item{\code{control}: }{List with test procedure options used.}
}
}
\description{
This function performs the CHP (2014) parameter stability test as outline in Carrasco, M., Hu, L. and Ploberger, W. (2014).
Original source code can be found \href{https://www.econometricsociety.org/content/supplement-optimal-test-markov-switching-parameters}{here}.
}
\references{
Carrasco, Marine, Liang Hu, and Werner Ploberger. 2014. “Optimal test for Markov switching parameters.” \emph{Econometrica} 82 (2): 765–784.
}
