% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{simuHMM_cpp}
\alias{simuHMM_cpp}
\title{Simulate Hidden Markov model with normally distributed errors}
\usage{
simuHMM_cpp(mdl_h0, burnin = 100L)
}
\arguments{
\item{mdl_h0}{List containing the following DGP parameters
\itemize{
  \item n: Length of series.
  \item k: Number of regimes.
  \item mu: A (\code{k x q}) vector of means.
  \item sigma: A (\code{q x q}) covariance matrix.
  \item q: Number of series.
  \item P: A (\code{k x k}) transition matrix (columns must sum to one).
  \item eps: An optional (\code{T+burnin x q}) matrix with standard normal errors to be used. Errors will be generated if not provided.
}}

\item{burnin}{Number of simulated observations to remove from beginning. Default is \code{100}.}
}
\value{
List with simulated series and its DGP parameters.
}
\description{
This function simulates a Hidden Markov Model process.
}
\keyword{internal}
