% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_segmentation_PELT.R
\name{fun_segmentation_PELT}
\alias{fun_segmentation_PELT}
\title{Detecting common change points for multiple signals.}
\usage{
fun_segmentation_PELT(Y, lambda, flag = 1, smooth_signals = TRUE)
}
\arguments{
\item{Y}{An data.frame/matrix containing the data within which you wish to find common change points. Each column is considered a separate signal.}

\item{lambda}{A penalty term to prevent over fitting.}

\item{flag}{Logical. If True then use th PELT method. If False then use the OP method.}

\item{smooth_signals}{Logical. If True then smooth signals are returned.}
}
\value{
An object of S4 class "MSigSeg"
}
\description{
Calculates the optimal positioning and number of common change points for multiple signals.
}
\details{
This function uses modified PELT method to find optimal common change points for multiple signals.
}
\examples{
data(PELT_test)
fun_segmentation_PELT(PELT_test,100)

}
