% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_grid.R
\name{construct_weekly_grid}
\alias{construct_weekly_grid}
\title{Computes the location-bandwidth weekly grid for the multiscale test.}
\usage{
construct_weekly_grid(t, min_len = 7, nmbr_of_wks = 4)
}
\arguments{
\item{t}{Sample size.}

\item{min_len}{Minimal length of the interval considered. The grid then
consists of intervals with lengths min_len,
2 * min_len, 3 * min_len, ... Default is 7, i.e. a week.}

\item{nmbr_of_wks}{Number that determines the longest intervals in the grid:
the length of this interval is calculated then as 
min_len * nmbr_of_wks. Default is 4.}
}
\value{
A list with the following elements:
   \item{gset}{Matrix of location-bandwidth points \eqn{(u, h)}
               the i-th row gset[i,] corresponds to the i-th point
               \eqn{(u,h)}.}
    \item{bws}{Vector of bandwidths.}
    \item{lens}{Vector of length = length(bws), lens[i] gives
                  the number of locations in the grid for
                  the i-th bandwidth level.}
    \item{gtype}{Type of grid that is used, always 'default'.}
    \item{gset_full}{Matrix of all location-bandwidth pairs \eqn{(u, h)}.}
}
\description{
Computes the location-bandwidth weekly grid for the multiscale test.
}
\examples{
construct_weekly_grid(100)
construct_weekly_grid(100, min_len = 7, nmbr_of_wks = 2)
}
