% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_lrv.R
\name{estimate_lrv}
\alias{estimate_lrv}
\title{Computes estimator of the long-run variance of the error terms.}
\usage{
estimate_lrv(data, q, r_bar, p)
}
\arguments{
\item{data}{A vector of \eqn{Y(1), Y(2), \ldots, Y(T)}.}

\item{q, r_bar}{Tuning parameters.}

\item{p}{AR order of the error terms.}
}
\value{
A list with the following elements:
    \item{lrv}{Estimator of the long run variance of the error terms
    \eqn{\sigma^2}.}
    \item{ahat}{Vector of length p of estimated AR coefficients
    \eqn{a_1,a_2,\ldots, a_p}.}
    \item{vareta}{Estimator of the variance of the innovation term \eqn{\nu^2}.}
}
\description{
A difference based estimator for the coefficients and
                 long-run variance in case of a nonparametric regression
                 model are AR(p).
                 
                 Specifically, we assume that we observe \eqn{Y(t)} that satisfy
                 the following equation: \deqn{Y(t) = m(t/T) + \epsilon_t.}
                 Here, \eqn{m(\cdot)} is an unknown function, and the errors
                 \eqn{\epsilon_t} are AR(p) with p known. Specifically, we ler
                 \eqn{\{\epsilon_t\}} be a process of the form
                 \deqn{\epsilon_t = \sum_{j=1}^p a_j \epsilon_{t-j} + \eta_t,} 
                 where \eqn{a_1,a_2,\ldots, a_p} are unknown coefficients and
                 \eqn{\eta_t} are i.i.d.\ with \eqn{E[\eta_t] = 0} and
                 \eqn{E[\eta_t^2] = \nu^2}.
                 
                 This function produces an estimator \eqn{\widehat{\sigma}^2}
                 of the long-run variance 
                 \deqn{\sigma^2 = \sum_{l=-\infty}^{\infty} cov(\epsilon_0,\epsilon_{l})}
                 of the error terms, as well as estimators
                 \eqn{\widehat{a}_1, \ldots, \widehat{a}_p} of the coefficients
                 \eqn{a_1,a_2,\ldots, a_p} and an estimator \eqn{\widehat{\nu}^2} of 
                 the innovation variance \eqn{\nu^2}.
                 
                 The exact estimation procedure as well as description of 
                 the tuning parameters needed for this estimation can be found
                 in Khismatullina and Vogt (2020).
}
\references{
Khismatullina M., Vogt M. Multiscale inference and long-run
            variance estimation in non-parametric regression with
            time series errors //Journal of the Royal Statistical Society:
            Series B (Statistical Methodology). - 2020.
}
