% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSmix_functions_package.R
\name{plot.dist}
\alias{plot.dist}
\title{Plot the Spearman distance matrix}
\usage{
\method{plot}{dist}(
  x,
  order = TRUE,
  show_labels = TRUE,
  lab_size = 3,
  gradient = list(low = "#00AFBB", mid = "white", high = "#FC4E07"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{"dist"}, returned by \code{\link{spear_dist}} when setting the argument \code{rho = NULL}.}

\item{order}{Logical: whether the rows of the distance matrix must be ordered. Defaults to \code{TRUE}.}

\item{show_labels}{Logical: whether the labels must be displayed on the axes. Defaults to \code{TRUE}.}

\item{lab_size}{Positive scalar: the magnification of the labels on the axes. Defaults to 3.}

\item{gradient}{List of three elements with the colors for low, mid and high values of the distances in the heatmap. The element \code{mid} can take the value of NULL.}

\item{...}{Further arguments passed to or from other methods (not used).}
}
\value{
Produce a heatmap of the Spearman distance matrix between all pairs of full rankings.
}
\description{
\code{plot} method for class \code{"dist"}. It is useful to preliminary explore the presence of patterns (groups) of similar preferences in the ranking dataset.
}
\details{
It can take a few seconds if the size of the distance matrix is large.

The heatmap can be also obtained by setting the arguments \code{rho = NULL} and \code{plot_dist_mat = TRUE} when applying \code{\link{spear_dist}}.
}
\examples{

## Example 1. Plot the Spearman distance matrix of the Antifragility ranking dataset.
dist_mat <- spear_dist(rankings = ranks_antifragility)
plot(dist_mat, show_labels = FALSE)

## Example 2. Plot the Spearman distance matrix of the Sports ranking dataset.
n <- 8
dist_mat <- spear_dist(rankings = ranks_sports[, 1:n])
plot(dist_mat, show_labels = FALSE)
# Plot the Spearman distance matrix for the subsample of males.
dist_m <- spear_dist(rankings = ranks_sports[, 1:n], subset = ranks_sports$Gender == "Male")
plot(dist_m)


}
\references{
Alboukadel K and Mundt F (2020). factoextra: Extract and Visualize the Results of Multivariate Data Analyses. R package version 1.0.7. \url{https://CRAN.R-project.org/package=factoextra}
}
\seealso{
\code{\link{spear_dist}}
}
