% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generates_transformation_functions.R
\name{generates_transformation_functions_T1}
\alias{generates_transformation_functions_T1}
\title{Function to generate data transformation functions for the T1 methods}
\usage{
generates_transformation_functions_T1(unit_space_data)
}
\arguments{
\item{unit_space_data}{Matrix with n rows (samples) and (p + 1) columns 
(variables). Data to generate the unit space. All 
data should be continuous values and should not have 
missing values.}
}
\value{
\code{generates_transformation_functions_T1} returns a list 
          containing three functions. For the first component, the data 
          transformation function for independent variables is a function 
          that subtracts the mean of each independent variable. For the 
          second component, the data transformation function for a dependent 
          variable is a function that subtracts the mean of a dependent 
          variable. For the third component, the inverse function of the data 
          transformation function for a dependent variable is a function that 
          adds the mean of a dependent variable. The mean used is the mean of 
          the \code{unit_space_data}.
}
\description{
\code{generates_transformation_functions_T1} is the argument for the 
  parameter \code{generates_transform_functions} in \code{genera_T}, which 
  is used in the T1 method. In addtion, the Ta method also uses this function 
  for the argument.
}
\examples{
   
# The value of the dependent variable of the following samples mediates  
# in the stackloss dataset.
stackloss_center <- stackloss[c(9, 10, 11, 20, 21), ] 
      
tmp <- generates_transformation_functions_T1(stackloss_center)
mean_subtraction_function <- tmp[[1]]
subtracts_M_0 <- tmp[[2]]
adds_M_0 <- tmp[[3]] 

is.function(mean_subtraction_function) # TRUE
is.function(subtracts_M_0) # TRUE
is.function(adds_M_0) # TRUE

}
\seealso{
\code{\link{T1}} and \code{\link{Ta}}
}

