% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{EvaluateIndividual}
\alias{EvaluateIndividual}
\title{Evaluate objective values of a single individual}
\usage{
EvaluateIndividual(individual, fun, ...)
}
\arguments{
\item{individual}{The individual to be evaluated}

\item{fun}{A string containing which problem is being solved. Currently available DTLZ1-DTLZ4, WFG4-WFG9.}

\item{...}{Further parameters used by \code{fun}}
}
\value{
A matrix of size nObjective, containing the objective values.
}
\description{
Evaluate individual with the specified test function. Non-feasible solution are given Inf as objective values.
}
\examples{
individual <- stats::runif(8)
EvaluateIndividual(individual,WFG4,3) # the 3 is passed to WFG4 nObj
}
