% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune.R
\name{tune}
\alias{tune}
\alias{tune.data.frame}
\alias{tune.formula}
\alias{tune.recipe}
\title{Model Tuning}
\usage{
tune(x, ...)

\method{tune}{data.frame}(x, model, grid = data.frame(),
  control = CVControl, metric = 1, stat = mean, maximize = TRUE,
  ...)

\method{tune}{formula}(x, data, model, grid = data.frame(),
  control = CVControl, metric = 1, stat = mean, maximize = TRUE,
  ...)

\method{tune}{recipe}(x, model, grid = data.frame(),
  control = CVControl, metric = 1, stat = mean, maximize = TRUE,
  ...)
}
\arguments{
\item{x}{defined relationship between model predictors and an outcome.  May
be a model.frame (data.frame) containing a formula, data, and optionally case
weights; a formula; or a recipe.}

\item{...}{arguments passed to other methods.}

\item{model}{constructor function or character string naming a constructor
function that returns an MLModel object.}

\item{grid}{data frame containing parameter values over which to evaluate the
\code{model} constructor function.}

\item{control}{\code{\linkS4class{MLControl}} object, control function, or
character string naming a control function defining the resampling method to
be employed.}

\item{metric}{numeric index or character name of the performance metric to
use in selecting the best model.}

\item{stat}{function to compute a summary statistic on resampled values of
the metric for model selection.  The supplied function should contain a
\code{na.rm} argument in its definition.}

\item{maximize}{logical indicating whether to select the model having the
maximum or minimum value of the performance metric.}

\item{data}{data frame containing observed predictors and outcomes.}
}
\value{
MLModelTune class object that inherits from MLModel.
}
\description{
Evaluate a model over a grid of tuning parameters and select the best one
according to resample estimation of predictive performance.
}
\examples{
\donttest{
## Survival response example
library(survival)

fo <- Surv(time, status) ~ age + sex + ph.ecog + ph.karno + pat.karno +
                           meal.cal + wt.loss

(gbmtune <- tune(fo, data = lung, model = GBMModel,
                 grid = expand.grid(n.trees = c(25, 50, 100),
                                    interaction.depth = 1:3,
                                    n.minobsinnode = c(5, 10)),
                 control = CVControl(folds = 10, repeats = 5,
                                     surv_times = c(180, 360, 540))))
summary(gbmtune)
plot(gbmtune, type = "line", metrics = c("ROC", "Brier"))

gbmfit <- fit(fo, data = lung, gbmtune)
varimp(gbmfit)
}

}
\seealso{
\code{\link[stats]{model.frame}}, \code{\link[recipes]{recipe}},
\code{\link{BootControl}}, \code{\link{CVControl}}, \code{\link{OOBControl}},
\code{\link{fit}}, \code{\link{resample}}, \code{\link{plot}},
\code{\link{summary}}
}
