% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_XGBModel.R
\name{XGBModel}
\alias{XGBModel}
\alias{XGBDARTModel}
\alias{XGBLinearModel}
\alias{XGBTreeModel}
\title{Extreme Gradient Boosting Models}
\usage{
XGBModel(params = list(), nrounds = 1, verbose = 0,
  print_every_n = 1)

XGBDARTModel(objective = NULL, base_score = 0.5, eta = 0.3,
  gamma = 0, max_depth = 6, min_child_weight = 1,
  max_delta_step = 0, subsample = 1, colsample_bytree = 1,
  colsample_bylevel = 1, lambda = 1, alpha = 0,
  tree_method = "auto", sketch_eps = 0.03, scale_pos_weight = 1,
  update = "grow_colmaker,prune", refresh_leaf = 1,
  process_type = "default", grow_policy = "depthwise",
  max_leaves = 0, max_bin = 256, sample_type = "uniform",
  normalize_type = "tree", rate_drop = 0, one_drop = 0,
  skip_drop = 0, ...)

XGBLinearModel(objective = NULL, base_score = 0.5, lambda = 0,
  alpha = 0, updater = "shotgun", feature_selector = "cyclic",
  top_k = 0, ...)

XGBTreeModel(objective = NULL, base_score = 0.5, eta = 0.3,
  gamma = 0, max_depth = 6, min_child_weight = 1,
  max_delta_step = 0, subsample = 1, colsample_bytree = 1,
  colsample_bylevel = 1, lambda = 1, alpha = 0,
  tree_method = "auto", sketch_eps = 0.03, scale_pos_weight = 1,
  update = "grow_colmaker,prune", refresh_leaf = 1,
  process_type = "default", grow_policy = "depthwise",
  max_leaves = 0, max_bin = 256, ...)
}
\arguments{
\item{params}{list of model parameters as described in the XBoost
\href{https://xgboost.readthedocs.io/en/latest/parameter.html}{documentation}.}

\item{nrounds}{maximum number of boosting iterations.}

\item{verbose}{numeric value controlling the amount of output printed
during model fitting, such that 0 = none, 1 = performance information, and
2 = additional information.}

\item{print_every_n}{numeric value designating the fitting iterations at
at which to print output when \code{verbose > 0}.}

\item{objective}{character string specifying the learning task and objective.
Set automatically according to the class type of the response variable.}

\item{base_score}{initial numeric prediction score of all instances, global
bias.}

\item{eta, gamma, max_depth, min_child_weight, max_delta_step, subsample, colsample_bytree, colsample_bylevel, lambda, alpha, tree_method, sketch_eps, scale_pos_weight, update, refresh_leaf, process_type, grow_policy, max_leaves, max_bin, sample_type, normalize_type, rate_drop, one_drop, skip_drop, updater, feature_selector, top_k}{see \code{params} reference.}

\item{...}{arguments to be passed to \code{XGBModel}.}
}
\value{
MLModel class object.
}
\description{
Fits models within an efficient implementation of the gradient boosting
framework from Chen & Guestrin.
}
\details{
\describe{
\item{Response Types:}{\code{factor}, \code{numeric}}
}

Default values for the \code{NULL} arguments and further model details can be
found in the source link below.

The following variable importance metrics are available for XBMTreeModel:
\enumerate{
  \item \code{Gain} fractional contribution of each predictor to the total
  gain of its splits.
  \item \code{Cover} number of observations related to each predictor.
  \item \code{Frequency} percentage of times each predictor is used in the
  trees.
}
In calls to \code{\link{varimp}} for these tree model fits, the first metric
will be returned by default.  Others may be specified to the \code{metrics}
argument of the function by their names or numeric indices.  Variable
importance is automatically scaled to range from 0 to 100.  To obtain
unscaled importance values, set \code{scale = FALSE}.  See example below.
}
\examples{
modelfit <- fit(Species ~ ., data = iris, model = XGBTreeModel())
varimp(modelfit, metrics = 1:3, scale = FALSE)

}
\seealso{
\code{\link[xgboost:xgb.train]{xgboost}}, \code{\link{fit}},
\code{\link{resample}}, \code{\link{tune}}
}
