% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\name{resample}
\alias{resample}
\alias{resample.formula}
\alias{resample.ModelFrame}
\alias{resample.recipe}
\title{Resample Estimation of Model Performance}
\usage{
resample(x, ...)

\method{resample}{formula}(x, data, model, control = CVControl, ...)

\method{resample}{ModelFrame}(x, model, control = CVControl, ...)

\method{resample}{recipe}(x, model, control = CVControl, ...)
}
\arguments{
\item{x}{defined relationship between model predictors and an outcome.  May
be a ModelFrame containing a formula, data, and optionally case weights; a
formula; or a recipe.}

\item{...}{arguments passed to other methods.}

\item{data}{data frame containing observed predictors and outcomes.}

\item{model}{MLModel object, constructor function, or character string
naming a constructor function that returns an MLModel object.}

\item{control}{\code{\linkS4class{MLControl}} object, control function, or
character string naming a control function defining the resampling method to
be employed.}
}
\value{
Resamples class object.
}
\description{
Estimation of the predictive performance of a model estimated and evaluated
on training and test samples generated from an observed data set.
}
\details{
Stratified resampling is performed for the \code{formula} method according to
values of the response variable; i.e. categorical levels for \code{factor},
continuous for \code{numeric}, and event status \code{Surv}.

User-specified stratification variables may be specified for
\code{\link[MachineShop:ModelFrame-methods]{ModelFrames}} upon
creation with the \code{strata} argument in its constructor.  Resampling of
this class is unstratified by default.

Variables in a \code{recipe} may be used for stratification by defining a
"case_strata" \code{\link[recipes:roles]{role}} for them.  Resampling will
be unstratified if no variables have that role.
}
\examples{
\donttest{
## Survival response example
library(survival)
library(MASS)

(gbmperf <- resample(Surv(time, status != 2) ~ sex + age + year + thickness + ulcer,
                     data = Melanoma, model = GBMModel,
                     control = CVControl(folds = 10, repeats = 5,
                                         surv_times = 365 * c(2, 5, 10))))
summary(gbmperf)
plot(gbmperf)
}

}
\seealso{
\code{\link{tune}}, \code{\link{ModelFrame}},
\code{\link[recipes]{recipe}}, \code{\link{BootControl}},
\code{\link{CVControl}}, \code{\link{OOBControl}}, \code{\link{Resamples}},
\code{\link{plot}}, \code{\link{summary}}
}
