% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit}
\alias{fit}
\alias{fit.formula}
\alias{fit.matrix}
\alias{fit.ModelFrame}
\alias{fit.recipe}
\alias{fit.MLModel}
\alias{fit.MLModelFunction}
\title{Model Fitting}
\usage{
fit(x, ...)

\method{fit}{formula}(x, data, model, ...)

\method{fit}{matrix}(x, y, model, ...)

\method{fit}{ModelFrame}(x, model, ...)

\method{fit}{recipe}(x, model, ...)

\method{fit}{MLModel}(x, ...)

\method{fit}{MLModelFunction}(x, ...)
}
\arguments{
\item{x}{\link[=inputs]{input} specifying a relationship between model
predictor and response variables.  Alternatively, a \link[=models]{model}
function or call may be given first followed by the input specification.}

\item{...}{arguments passed to other methods.}

\item{data}{\link[=data.frame]{data frame} containing observed predictors and
outcomes.}

\item{model}{\link[=models]{model} function, function name, or call; ignored
and can be omitted when fitting \link[=ModeledInput]{modeled inputs}.}

\item{y}{response variable.}
}
\value{
\code{MLModelFit} class object.
}
\description{
Fit a model to estimate its parameters from a data set.
}
\details{
User-specified case weights may be specified for \code{ModelFrames} upon
creation with the \code{\link[=ModelFrame]{weights}} argument in its
constructor.

Variables in \code{recipe} specifications may be designated as case weights
with the \code{\link{role_case}} function.
}
\examples{
\donttest{
## Requires prior installation of suggested package gbm to run

## Survival response example
library(survival)

gbm_fit <- fit(Surv(time, status) ~ ., data = veteran, model = GBMModel)
varimp(gbm_fit)
}

}
\seealso{
\code{\link{as.MLModel}}, \code{\link{response}},
\code{\link{predict}}, \code{\link{varimp}}
}
