% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_RandomForestModel.R
\name{RandomForestModel}
\alias{RandomForestModel}
\title{Random Forest Model}
\usage{
RandomForestModel(
  ntree = 500,
  mtry = .(if (is.factor(y)) floor(sqrt(nvars)) else max(floor(nvars/3), 1)),
  replace = TRUE,
  nodesize = .(if (is.factor(y)) 1 else 5),
  maxnodes = integer()
)
}
\arguments{
\item{ntree}{number of trees to grow.}

\item{mtry}{number of variables randomly sampled as candidates at each split.}

\item{replace}{should sampling of cases be done with or without replacement?}

\item{nodesize}{minimum size of terminal nodes.}

\item{maxnodes}{maximum number of terminal nodes trees in the forest can
have.}
}
\value{
\code{MLModel} class object.
}
\description{
Implementation of Breiman's random forest algorithm (based on Breiman and
Cutler's original Fortran code) for classification and regression.
}
\details{
\describe{
  \item{Response types:}{\code{factor}, \code{numeric}}
  \item{\link[=TunedModel]{Automatic tuning} of grid parameters:}{
    \code{mtry}, \code{nodesize}*
  }
}
* excluded from grids by default

Default values and further model details can be found in the source link
below.
}
\examples{
\donttest{
## Requires prior installation of suggested package randomForest to run

fit(sale_amount ~ ., data = ICHomes, model = RandomForestModel)
}

}
\seealso{
\code{\link[randomForest]{randomForest}}, \code{\link{fit}},
\code{\link{resample}}
}
