% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varimp.R
\name{varimp}
\alias{varimp}
\title{Variable Importance}
\usage{
varimp(object, method = c("permute", "model"), scale = TRUE, ...)
}
\arguments{
\item{object}{model \link{fit} result.}

\item{method}{character string specifying the calculation of variable
importance as permutation-base (\code{"permute"}) or model-specific
(\code{"model"}).  If model-specific importance is specified but not
defined, the permutation-based method will be used instead with its default
values (below).  Permutation-based variable importance is defined as the
relative change in model predictive performances between datasets with and
without permuted values for the associated variable (Fisher et al. 2019).}

\item{scale}{logical indicating whether importance values should be scaled to
a maximum of 100.}

\item{...}{arguments passed to model-specific or permutation-based variable
importance functions.  These include the following arguments and default
values for \code{method = "permute"}.
\describe{
  \item{\code{select = NULL}}{expression indicating predictor variables for
    which to compute variable importance (see \code{\link[base]{subset}}
    for syntax) [default: all].}
  \item{\code{samples = 1}}{number of times to permute the values of each
    variable.  Larger numbers of samples decrease variability in the
    estimates at the expense of increased computation time.}
  \item{\code{prop = numeric()}}{proportion of observations to sample
    without replacement at each round of variable permutations [default:
    all].  Subsampling of observations can decrease computation time.}
  \item{\code{size = integer()}}{number of observations to sample at each
    round of permutations [default: all].}
  \item{\code{times = numeric()}}{numeric vector of follow-up times at
    which to predict survival probabilities or \code{NULL} for predicted
    survival means.}
  \item{\code{metric = NULL}}{\link[=metrics]{metric} function or function
    name with which to calculate performance.  If not specified, the first
    applicable default metric from the \link{performance} functions is
    used.}
  \item{\code{compare = c("-", "/")}}{character specifying the relative
    change to compute in comparing model predictive performances between
    datasets with and without permuted values.  The choices are difference
    (\code{"-"}) and ratio (\code{"/"}).}
  \item{\code{stats = MachineShop::settings("stat.TrainingParams")}}{
    function, function name, or vector of these with which to compute
    summary statistics on the set of variable importance values from the
    permuted datasets.}
  \item{\code{na.rm = TRUE}}{logical indicating whether to exclude missing
    variable importance values from the calculation of summary statistics.}
  \item{\code{progress = TRUE}}{logical indicating whether to display
    iterative progress during computation.}
}}
}
\value{
\code{VariableImportance} class object.
}
\description{
Calculate measures of the relative importance of predictors in a model.
}
\examples{
\donttest{
## Requires prior installation of suggested package gbm to run

## Survival response example
library(survival)

gbm_fit <- fit(Surv(time, status) ~ ., data = veteran, model = GBMModel)
(vi <- varimp(gbm_fit))
plot(vi)
}

}
\references{
Fisher, A., Rudin, C., & Dominici, F. (2019). All models are wrong, but many
are useful: Learning a variable's importance by studying an entire class of
prediction models simultaneously. \emph{Journal of Machine Learning
Research}, \emph{20}, 1-81.
}
\seealso{
\code{\link{plot}}
}
