% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate-data.R
\name{simu_db}
\alias{simu_db}
\title{Simulate a dataset tailored for MagmaClustR}
\usage{
simu_db(
  M = 10,
  N = 10,
  K = 1,
  covariate = FALSE,
  grid = seq(0, 10, 0.05),
  common_input = TRUE,
  common_hp = TRUE,
  add_hp = FALSE,
  add_clust = FALSE,
  int_mu_v = c(0, 2),
  int_mu_l = c(0, 2),
  int_i_v = c(0, 2),
  int_i_l = c(0, 2),
  int_i_sigma = c(0, 1),
  m0_slope = c(-5, 5),
  m0_intercept = c(-10, 10),
  int_covariate = c(-5, 5)
)
}
\arguments{
\item{M}{An integer. The number of individual per cluster.}

\item{N}{An integer. The number of observations per individual.}

\item{K}{An integer. The number of underlying clusters.}

\item{covariate}{A logical value indicating whether the dataset should
include an additional input covariate named 'Covariate'.}

\item{grid}{A vector of numbers defining a grid of observations
(i.e. the reference inputs).}

\item{common_input}{A logical value indicating whether the reference inputs
are common to all individual.}

\item{common_hp}{A logical value indicating whether the hyper-parameters are
common to all individual. If TRUE and K>1, the hyper-parameters remain
different between the clusters.}

\item{add_hp}{A logical value indicating whether the values of
hyper-parameters should be added as columns in the dataset.}

\item{add_clust}{A logical value indicating whether the name of the
clusters should be added as a column in the dataset.}

\item{int_mu_v}{A vector of 2 numbers, defining an interval of admissible
values for the variance hyper-parameter of the mean process' kernel.}

\item{int_mu_l}{A vector of 2 numbers, defining an interval of admissible
values for the lengthscale hyper-parameter of the mean process' kernel.}

\item{int_i_v}{A vector of 2 numbers, defining an interval of admissible
values for the variance hyper-parameter of the individual process' kernel.}

\item{int_i_l}{A vector of 2 numbers, defining an interval of admissible
values for the lengthscale hyper-parameter of the individual process'
kernel.}

\item{int_i_sigma}{A vector of 2 numbers, defining an interval of admissible
values for the noise hyper-parameter.}

\item{m0_slope}{A vector of 2 numbers, defining an interval of admissible
values for the slope of m0.}

\item{m0_intercept}{A vector of 2 numbers, defining an interval of admissible
values for the intercept of m0.}

\item{int_covariate}{A vector of 2 numbers, defining an interval of
admissible values for the covariate inputs.}
}
\value{
A full dataset of simulated training data.
}
\description{
Simulate a complete training dataset, which may be representative of various
applications. Several flexible arguments allow adjustment of the number of
individuals, of observed inputs, and the values of many parameters
controlling the data generation.
}
\examples{
## Generate a dataset with 3 clusters of 4 individuals, observed at 10 inputs
data = simu_db(M = 4, N = 10, K = 3)

## Generate a 2-D dataset with an additional input 'Covariate'
data = simu_db(covariate = TRUE)

## Generate a dataset where input locations are different among individuals
data = simu_db(common_input = FALSE)

## Generate a dataset with an additional column indicating the true clusters
data = simu_db(K = 3, covariate = TRUE)
}
