% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchitmice.R
\name{matchitmice}
\alias{matchitmice}
\title{Matches Multiply Imputed Datasets}
\usage{
matchitmice(formula, datasets, method = "nearest", distance = "logit",
  distance.options = list(), discard = "none", reestimate = FALSE,
  ...)
}
\arguments{
\item{formula}{This argument takes the usual syntax of R formula, \code{y ~ x1 + x2}, where \code{y} is a binary treatment indicator and \code{x1} and \code{x2} are the matching covariates. Both the treatment indicator and matching covariates must be contained in the imputed datasets, which are specified as \code{datasets} (see below). All of the usual R syntax for formula works. For example, \code{x1:x2} represents the first order interaction term between \code{x1} and \code{x2} and \code{I(x1^2)} represents the square term of \code{x1}. See \code{help(formula)} for details.}

\item{datasets}{This argument specifies the datasets containing the treatment indicator and matching covariates called in the \code{formula}. This argument must be an object of the \code{mids} class, which is typically produced by a previous call to \code{mice()} or \code{mice.mids()} functions from the \pkg{mice} package.}

\item{method}{This argument specifies a matching method. Currently, \code{"nearest"} (nearest neighbor matching) and \code{"exact"} (exact matching) methods are available. The default is \code{"nearest"}. Note that within each of these matching methods, \pkg{MatchIt.mice} offers a variety of options.}

\item{distance}{This argument specifies the method used to estimate the distance measure. The default is logistic regression, \code{"logit"}. A variety of other methods are available.}

\item{distance.options}{This optional argument specifies the optional arguments that are passed to the model for estimating the distance measure. The input to this argument should be a list.}

\item{discard}{This argument specifies whether to discard individuals that fall outside some measure of support of the distance score before matching, and not allow them to be used at all in the matching procedure. Note that discarding individuals may change the quantity of interest being estimated. The current options are \code{"none"} (discarding no individuals before matching), \code{"both"} (discarding all individuals, both the control and treatment individuals, that are outside the support of the distance measure), \code{"control"} (discarding only control individuals outside the support of the distance measure of the treatment individuals), and \code{"treat"} (discarding only treatment individuals outside the support of the distance measure of the control individuals). The default is \code{"none"}.}

\item{reestimate}{This argument specifies whether the model for estimating the distance measure should be reestimated after individuals are discarded. The input must be a logical value. The default is \code{FALSE}.}

\item{...}{Additional arguments to be passed to the matching method.}
}
\value{
This function returns an object of the \code{mimids} (matched multiply imputed datasets) class, that includes matched subsets of the imputed datasets primarily passed to the function by the \code{datasets} argument.
}
\description{
The \code{matchitmice()} function enables parametric models for causal inference to work better by selecting matched subsets of the control and treatment groups of imputed datasets of a \code{mids} class object.
}
\details{
The matching is done using the \code{matchitmice(y ~ x1, ...)} command, where \code{y} is the vector of treatment assignments and \code{x1} represents the covariates to be used in the matching model. There are a number of matching options, detailed below. The default syntax is \code{matchitmice(formula, datasets = NULL, method = "nearest", model = "logit", ratio = 1, caliper = 0, ...)}. Summaries of the results can be seen graphically using \code{plot()} or numerically using \code{summary()} functions. The \code{print()} function also prints out the output.
}
\examples{

#Please see the package repository <https://github.com/FarhadPishgar/MatchIt.mice> for details.

#Loading the 'handoa' dataset
data(handoa)

#Imputing the missing data points in the'handoa' dataset
datasets <- mice(handoa, m = 5, maxit = 1,
                 method = c("", "", "", "mean", "polyreg", "logreg", "", ""))

#Matching the imputed datasets, 'datasets'
matcheddatasets <- matchitmice(HANDOA ~ SEX + AGE, datasets, method = 'exact')

}
\references{
Daniel Ho, Kosuke Imai, Gary King, and Elizabeth Stuart (2007). Matching as Nonparametric Preprocessing for Reducing Model Dependence in Parametric Causal Inference. \emph{Political Analysis}, 15(3): 199-236. \url{http://gking.harvard.edu/files/abs/matchp-abs.shtml}

Stef van Buuren and Karin Groothuis-Oudshoorn (2011). \code{mice}: Multivariate Imputation by Chained Equations in \code{R}. \emph{Journal of Statistical Software}, 45(3): 1-67. \url{https://www.jstatsoft.org/v45/i03/}
}
\seealso{
\code{\link[=mimids]{mimids}}

\code{\link[=with]{with}}

\code{\link[=pool]{pool}}
}
\author{
Farhad Pishgar
}
