\name{plotFrontier}
\alias{plotFrontier}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Plot the balance - sample size frontier.
}
\description{
    \code{plotFrontier()} plots the balance - sample size frontier. 
}
\usage{
plotFrontier(frontier.object, xlab = "Number of Observations Pruned",
             ylab = frontier.object$metric, main = "Frontier Plot", ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{frontier.object}{
    An object generated by \code{makeFrontier()}
  }
  \item{xlab}{
    The label for the x-axis. Defaults to 'Number of Observations Pruned'.
  }
  \item{ylab}{
    The label for the y-axis. Defaults to the selected metric.
  }
  \item{main}{
    The main label. Defaults to 'Effects Plot'.
  }
  \item{\dots}{
    Additional arguments to be passed to \code{plot}.
  }
}
\details{
  \code{plotEstimates()} wraps \code{plot} and uses \dots to
  pass additional arguments to the base \code{plot()} function,
  like color, axis range, etc. 
}
\examples{
data(lalonde)

match.on <- colnames(lalonde)[!(colnames(lalonde) \%in\% c('re78', 'treat'))]
my.frontier <- makeFrontier(dataset = lalonde,
                            treatment = 'treat',
                            outcome = 're78',
                            match.on = match.on)

plotFrontier(my.frontier)
}
\references{
  King, Gary, Christopher Lucas, and Richard
  Nielsen. "The Balance-Sample 
  Size Frontier in Matching Methods for Causal Inference." (2015).
}
