\name{RsparseMatrix-class}
\docType{class}
\alias{RsparseMatrix-class}
%
\alias{coerce,RsparseMatrix,CsparseMatrix-method}
\alias{coerce,RsparseMatrix,TsparseMatrix-method}
\alias{coerce,RsparseMatrix,denseMatrix-method}
\alias{coerce,RsparseMatrix,dgeMatrix-method}
\alias{coerce,RsparseMatrix,matrix-method}
\alias{coerce,RsparseMatrix,dsparseMatrix-method}
\alias{coerce,RsparseMatrix,lsparseMatrix-method}
\alias{coerce,RsparseMatrix,nsparseMatrix-method}
\alias{coerce,RsparseMatrix,dMatrix-method}
\alias{coerce,RsparseMatrix,lMatrix-method}
\alias{coerce,RsparseMatrix,nMatrix-method}
\alias{coerce,matrix,RsparseMatrix-method}
\alias{coerce,ddenseMatrix,RsparseMatrix-method}
\alias{coerce,dsparseMatrix,RsparseMatrix-method}
% all other ..RMatrix coercions -- here as well for now --
\alias{coerce,matrix,dgRMatrix-method}
%
\alias{colSums,dgRMatrix-method}
\alias{colMeans,dgRMatrix-method}
\alias{t,RsparseMatrix-method}
%
\title{Class "RsparseMatrix" of Sparse Matrices in Column-compressed Form}
\description{The \code{"RsparseMatrix"} class is the virtual class of
  all sparse matrices coded in sorted compressed row-oriented form.
  Since it is a virtual class, no objects may be created from it.  See
  \code{showClass("RsparseMatrix")} for its subclasses.
}
\section{Slots}{
  \describe{
    \item{\code{j}:}{Object of class \code{"integer"} of length \code{nnzero}
      (number of non-zero elements).  These are the row numbers for
      each non-zero element in the matrix.}
    \item{\code{p}:}{Object of class \code{"integer"} of pointers, one
      for each row, to the initial (zero-based) index of elements in
      the row.}
    \item{\code{Dim}, \code{Dimnames}:}{inherited from
      the superclass, see \code{\linkS4class{sparseMatrix}}.}
  }
}
\section{Extends}{
  Class \code{"sparseMatrix"}, directly.
  Class \code{"Matrix"}, by class \code{"sparseMatrix"}.
}
\section{Methods}{
  Only \bold{few} methods are defined currently on purpose, since we
  rather use the \code{\linkS4class{CsparseMatrix}} in \pkg{Matrix}.
  \describe{
    \item{t}{\code{signature(x = "RsparseMatrix")}: ... }
    \item{coerce}{\code{signature(from = "RsparseMatrix", to = "CsparseMatrix")}: ... }
    \item{coerce}{\code{signature(from = "RsparseMatrix", to = "TsparseMatrix")}: ... }
    \item{colSums}{\code{signature(x = "dgRMatrix")}: ... }
    \item{colMeans}{\code{signature(x = "dgRMatrix")}: ... }
  }
}
\seealso{
  its superclass, \code{\linkS4class{sparseMatrix}}, and, e.g., class
  \code{\linkS4class{dgRMatrix}} for the links to other classes.
}
\examples{
showClass("RsparseMatrix")
}
\keyword{classes}
