% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sudoku.R
\name{sudoku}
\alias{sudoku}
\alias{get_pairs_of_data_frame}
\alias{generate_points_between_two_points}
\alias{get_tracer_bullets}
\title{The function to get the best tracer bullets related to kernel mean embedding}
\usage{
sudoku(DT, iKernelABC, n_bullets = 20, n_best = 10, halfwidth = 0.5)

get_pairs_of_data_frame(DF)

generate_points_between_two_points(pair, n = 10)

get_tracer_bullets(DF, n_bullets = 20)
}
\arguments{
\item{DT}{Whole dataset of parameters}

\item{iKernelABC}{Result of calculations based on Isolation Kernel ABC
that can be gotten by the function \code{get.MaxWiK()}}

\item{n_bullets}{Integer number of tracer points between each pair of points from DF}

\item{n_best}{Integer number of the best tracer bullets / points
to consider them at the next algorithmic step}

\item{halfwidth}{Criterion to choose the best tracer points like: \cr
\code{if similarity_of_point >= halfwidth} then it is the point to be included to the pool of the best points}

\item{DF}{Data frame of oints that is used for generation of tracer points,
so it is usually a subset of points corresponding to Voronoi sites/seeds}

\item{pair}{Data frame of two points}

\item{n}{Integer number of points that should be located between two input points}
}
\value{
The function \code{sudoku()} returns the list of next objects:
\itemize{
\item tracer_bullets that is all the points generated during the run of the algorithm,
\item criterion that is a value of the similarity that is used to choose the best tracer points,
\item best_tracer_bullets that is the best tracer points that have similarity more or equal than \strong{criterion} value,
\item surroundings_best_points that is the best tracer points that have similarity more or equal than \strong{halfwidth} value,
\item feature_tracers that is results of the function \code{get_voronoi_feature_PART_dataset()} applied to the new tracer points,
\item similarity_to_mean that is numeric vector of similarities of all the tracers points.
}

The function \code{get_pairs_of_data_frame()} returns the list of the pairs of points

The function \code{generate_points_between_two_points()}
returns data frame of generated points between two given points,
including given points as the first and the last rows

The function \code{get_tracer_bullets()} returns data frame of generated tracer points
}
\description{
The function \code{sudoku()} allows to get the best tracer bullets related to kernel mean embedding.
The calculation performs ONLY for parameters dataset DT = par.sim.
This function performs a heuristic algorithm to seek a space/area related to
the feature mapping in Hilbert space for the dataset of the parameters. \cr
The main idea of the algorithm is just: \cr
\enumerate{
\item Generate points between the centers of Voronoi diagrams related to
the Maxima weighted feature mapping based on Isolation Kernel \cr
\item Following strategy to puzzle out of SUDOKU: delete all points that do not match feature mapping \cr
\item Output: The remaining points should be corresponding to the feature mapping.
}

The function \code{get_pairs_of_data_frame()} is used to get pairs of points
from the Data Frame that is the most distant each other.
In other words, the algorithm seeks the most distant coupled point to each point from the data frame

The function \code{generate_points_between_two_points()} is used to generate
points between two given points

The function \code{get_tracer_bullets()} is used to to get 'tracer bullets' or tracer points
generated between all the pairs of the most distant points
}
\section{Functions}{
\itemize{
\item \code{get_pairs_of_data_frame()}: The function to get pairs from Data Frame

\item \code{generate_points_between_two_points()}: The function to generate points between the pair of given points

\item \code{get_tracer_bullets()}: The function to get 'tracer bullets' or tracer points

}}
\examples{
NULL

NULL 
NULL
NULL 
}
\keyword{internal}
