% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods.R
\name{decide_delta}
\alias{decide_delta}
\title{decide delta data-dependently}
\usage{
decide_delta(
  object,
  gen.size = 500,
  step_delta = 0.1,
  MAX_iter = 100,
  verbose = FALSE
)
}
\arguments{
\item{object}{Object of class inheriting from "Maximin"}

\item{gen.size}{The generating sample size (Default = 500)}

\item{step_delta}{The step size of searching delta (Default = 0.1)}

\item{MAX_iter}{Maximum of iterations for searching (Default = 100)}

\item{verbose}{Print information about delta and reward (Default = `FALSE`)}
}
\value{
\item{delta}{The data-dependent ridge penalty}
\item{reward.ratio}{The ratio of penalized reward over non-penalized reward}
}
\description{
\code{decide_delta} will tell if the estimator is stable or not without ridge penalty
at first. If instable, it picks a ridge penalty data-dependently.
}
\examples{
## The problem is low-dimensional for testings
## heterogenous data and covariates shift
X1 = sample_data$X1
X2 = sample_data$X2
Y1 = sample_data$Y1
Y2 = sample_data$Y2
X.target = sample_data$X.target

## loading
loading = rep(0, 5) # dimension p=5
loading[5] = 1

## call
mm <- Maximin(list(X1, X2), list(Y1, Y2), loading, X.target)
out <- decide_delta(mm, gen.size=5)
out$delta
out$reward.ratio
}
