% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseDatetime.R
\name{parseDatetime}
\alias{parseDatetime}
\title{Parse datetime strings}
\usage{
parseDatetime(datetime = NULL, timezone = NULL, expectAll = FALSE)
}
\arguments{
\item{datetime}{vector of character or integer datetimes in Ymd[HMS] format
(or POSIXct).}

\item{timezone}{Olson timezone at the location of interest.}

\item{expectAll}{Logical value determining if the function should fail if
any elements fail to parse (default \code{FALSE}).}
}
\value{
A vector of POSIXct datetimes.
}
\description{
Transforms numeric and string representations of Ymd[HMS] datetimes to
\code{POSIXct} format.

Ymd, YmdH, YmdHM, and YmdHMS formats are understood, where:

\describe{
  \item{Y}{four digit year}
  \item{m}{decimal number (1-12, 01-12) or english name month (October, oct.)}
  \item{d}{decimal number day of the month (0-31 or 01-31)}
  \item{H}{decimal number hours (0-24 or 00-24)}
  \item{M}{decimal number minutes (0-59 or 00-59)}
  \item{S}{decimal number seconds (0-61 or 00-61)}
}

This allows for mixed inputs. For example, 20181012130900,
"2018-10-12-13-09-00", and "2018 Oct. 12 13:09:00" will all be converted to
the same \code{POSIXct} datetime. The incoming datetime vector does not need
to have a homogeneous format either -- "20181012" and "2018-10-12 13:09" can
exist in the same vector without issue. All incoming datetimes will be
interpreted in the specified timezone.

If \code{datetime} is a \code{POSIXct} it will be returned unmodified, and
formats not recognized will be returned as \code{NA}.
}
\section{Mazama Science Conventions}{

Within Mazama Science package, datetimes not in \code{POSIXct} format are
often represented as decimal values with no separation (ex: 20181012,
20181012130900), either as numerics or strings.
}

\section{Implementation}{

\code{parseDatetime} is essentially a wrapper around
\code{\link[lubridate]{parse_date_time}}, handling which formats we want to
account for.
}

\examples{
starttime <- parseDatetime(2015080718, timezone = "America/Los_Angeles")
datetimes <- parseDatetime(
  c("20181014 12", "20181015 12", "20181016 12"),
  timezone = "America/New_York"
)

\dontrun{
badInput <- c("20181013", NA, "20181015", "181016", "10172018")

# This will return a vector with the date that were able to parse
parseDatetime(badInput, timezone = "UTC", expectAll = FALSE)

# This will return an error, since some non-NA indices didn't parse
parseDatetime(badInput, timezone = "UTC", expectAll = TRUE)
}

}
\seealso{
\code{\link[lubridate]{parse_date_time}} for implementation details.
}
