% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dateRange.R
\name{dateRange}
\alias{dateRange}
\title{Create a POSIXct date range}
\usage{
dateRange(startdate = NULL, enddate = NULL, timezone = NULL,
  unit = "sec", ceilingEnd = FALSE, days = 7)
}
\arguments{
\item{startdate}{Desired start datetime (ISO 8601).}

\item{enddate}{Desired end datetime (ISO 8601).}

\item{timezone}{Olson timezone used to interpret dates (required).}

\item{unit}{Units used to determine time at end-of-day.}

\item{ceilingEnd}{Logical instruction to apply
\code{\link[lubridate]{ceiling_date}} to the \code{enddate} rather than
\code{\link[lubridate]{floor_date}}}

\item{days}{Number of days of data to include.}
}
\value{
A vector of two \code{POSIXct}s.
}
\description{
Create a POSIXct date range
}
\section{Default Arguments}{

In the case when either \code{startdate} or \code{enddate} is missing, it is
created from the non-missing values plus/minus \code{days}. If both
\code{startdate} and \code{enddate} are misssing, \code{enddate} is set to
\code{\link[lubridate]{now}} (with the given \code{timezone}), and then
\code{startdate} is calculated using \code{enddate - days}.
}

\section{End-of-Day Units}{

The second of the returned \code{POSIXct}s will end one \code{unit} before
the specified \code{enddate}. Acceptable units are \code{"day",
"hour", "min", "sec"}.

The aim is to quickly calculate full-day date ranges for time series whose
values are binned at different units. Thus, if \code{unit = "min"}, the
returned value associated with \code{enddate} will always be at 23:59:00
in the requested time zone.
}

\section{POSIXct inputs}{

When \code{startdate} or \code{enddate} are already \code{POSIXct} values,
they are converted to the timezone specified by \code{timezone} without
altering the physical instant in time the input represents. This is different
from the behavior of \code{\link[lubridate]{parse_date_time}} (which powers
this function), which will force \code{POSIXct} inputs into a new timezone,
altering the physical moment of time the input represents.
}

\examples{
dateRange("2019-01-08", timezone = "UTC")
dateRange("2019-01-08", unit = "min", timezone = "UTC")
dateRange("2019-01-08", unit = "hour", timezone = "UTC")
dateRange("2019-01-08", unit = "day", timezone = "UTC")
dateRange("2019-01-08", "2019-01-11", timezone = "UTC")
dateRange(enddate = 20190112, days = 3,
          unit = "day", timezone = "America/Los_Angeles")
}
