% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertWikipediaTimezoneTable.R
\name{convertWikipediaTimezoneTable}
\alias{convertWikipediaTimezoneTable}
\title{Convert Wikipedia Timezone Table to Dataframe}
\usage{
convertWikipediaTimezoneTable()
}
\value{
Dataframe with 399 rows and 6 columns.
}
\description{
Returns a dataframe version of the Wikipedia timezone table with the following columns:
\itemize{
  \item{timezone -- Olson timezone}
  \item{UTC_offset -- hours between local timezone and UTC}
  \item{UTC_DST_offset -- hours between local timezone daylight savings and UTC}
  \item{countryCode -- ISO 3166-2 country code}
  \item{longitude -- longitude of the Olson timezone city}
  \item{latitude -- latitude of the Olson timezone city}
}
}
\details{
Older named timezones from the table which are linked to more modern 
equivalents are not included in the returned dataframe.
}
\references{
\url{http://en.wikipedia.org/wiki/List_of_tz_database_time_zones}
}
\keyword{datagen}
