% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertWorldTimezones.R
\name{convertWorldTimezones}
\alias{convertWorldTimezones}
\title{Convert Timezone Shapefile}
\usage{
convertWorldTimezones(nameOnly = FALSE, simplify = TRUE)
}
\arguments{
\item{nameOnly}{Logical specifying whether to only return the name without
creating the file.}

\item{simplify}{Logical specifying whether to create "_05", _02" and "_01"
versions of the file that are simplified to 5\%, 2\% and 1\%.}
}
\value{
Name of the dataset being created.
}
\description{
Create a SpatialPolygonsDataFrame for world timezones.
}
\details{
A world timezones shapefile is downloaded and converted to a
SpatialPolygonsDataFrame with additional columns of data. The resulting file
will be created in the spatial data directory which is set with
\code{setSpatialDataDir()}.

The source data is from 2020 --
\href{https://github.com/evansiroky/timezone-boundary-builder/releases/tag/2020d}{release 2020d}.
}
\note{
From the source documentation:

Each shape or geojson object has a single attribute or property respectively
called tzid. The tzid corresponds to the timezone name as defined in the
timezone database (for example: America/Los_Angeles or Asia/Shanghai).

This project aims to stay up-to-date with all of the currently valid timezones
that are defined in the timezone database. This project also will attempt to
provide the most accurate possible boundaries of timezones according to
community input.

The underlying data is downloaded from OpenStreetMap via the overpass turbo
API. Various boundaries are assembled together to produce each zone with
various geographic operations.
}
\references{
\url{https://github.com/evansiroky/timezone-boundary-builder}
}
\seealso{
setSpatialDataDir

getTimezone

convertWikipediaTimezoneTable
}
\keyword{datagen}
