% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertOSMTimezones.R
\name{convertOSMTimezones}
\alias{convertOSMTimezones}
\title{Convert OSM timezone shapefile}
\usage{
convertOSMTimezones()
}
\value{
Name of the datasetName being created.
}
\description{
Create a simple features data frame for world timezones.

The full resolution file will be named "OSMTimezones.rda". In addition,
"_05", _02" and "_01" versions of the file will be created that that are
simplified to 5\%, 2\% and 1\%. Simplified versions will greatly improve the
speed of both searching and plotting.
}
\details{
A world timezone shapefile is downloaded and converted to a
simple features data frame with additional columns of data. The resulting file
will be created in the spatial data directory which is set with
\code{setSpatialDataDir()}.

There are 2 timezones which have polygons but the associated rows in the dataframe have no data.
These timezones also have no \code{countryCode} assigned. We hope to rectify this in a future release.
These are the missing timezones:
\preformatted{
> OSMTimezones$timezone[is.na(OSMTimezones$countryCode)]
 [1] "America/Nuuk"  "Asia/Qostanay"
}
}
\note{
From the source documentation:

This project aims to stay up-to-date with all of the currently valid
timezones that are defined in the timezone database. This project also will
attempt to provide the most accurate possible boundaries of timezones
according to community input.

The underlying data is downloaded from OpenStreetMap via the overpass turbo
API. Various boundaries are assembled together to produce each zone with
various geographic operations. In numerous edge cases arbitrary boundaries
get created in various zones which are noted in the timezones.json file.

To maintain consistency with the timezone database, this project will only
create a new release after the timezone database creates a new release. If
there are no new timezones created or deleted in a timezone database release,
then this project will only create a release if there have been changes
performed to the boundary definitions of an existing zone within this project.
}
\references{
\url{https://github.com/evansiroky/timezone-boundary-builder}
}
\keyword{datagen}
