% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertUSCensusStates.R
\name{convertUSCensusStates}
\alias{convertUSCensusStates}
\title{Convert US Census state shapefile}
\usage{
convertUSCensusStates()
}
\value{
Name of the datasetName being created.
}
\description{
Create a simple features dataframe for US states

The full resolution file will be named "USCensusStates". In addition,
"_05", _02" and "_01" versions of the file will be created that that are
simplified to 5\%, 2\% and 1\%. Simplified versions will greatly improve the
speed of both searching and plotting.
}
\details{
A US state borders shapefile is downloaded and converted to a
simple features dataframe with additional columns of data. The resulting file
will be created in the spatial data directory which is set with
\link{setSpatialDataDir}.

The source data is from 2021.
}
\note{
From the source documentation:

\strong{Cartographic Boundary Files}

The cartographic boundary files are simplified representations of
selected geographic areas from the U.S. Census Bureau's Master Address File /
Topologically Integrated Geographic Encoding and Referencing (MAF/TIGER)
Database (MTDB). These boundary files are specifically designed for
small-scale thematic mapping. When possible, generalization is performed with
the intent to maintain the hierarchical relationships among geographies and
to maintain the alignment of geographies within a file set for a given year.
To improve the appearance of shapes, areas are represented with fewer vertices
than detailed TIGER/Line equivalents. Some small holes or discontiguous parts
of areas are not included in generalized files. Generalized boundary files
are clipped to a simplified version of the U.S. outline. As a result, some
offshore areas may be excluded from the generalized files.

\strong{Limitations}

Geographic areas may not align with the same areas from another year. Some
geographies are available as nation-based files while others are available
only as state-based files.

States and equivalent entities are the primary governmental divisions of the
United States. In addition to the fifty states, the Census Bureau treats the
District of Columbia, Puerto Rico, and each of the Island Areas (American
Samoa, the Commonwealth of the Northern Mariana Islands, Guam, and the U.S.
Virgin Islands) as the statistical equivalents of states for the purpose of
data presentation.

\strong{\emph{"Island Areas" are removed in the MazamaSpatialUtils version.}}

These files were specifically created to support small-scale thematic mapping.
To improve the appearance of shapes at small scales, areas are represented
with fewer vertices than detailed TIGER/Line Shapefiles. Cartographic boundary
files take up less disk space than their ungeneralized counterparts.
Cartographic boundary files take less time to render on screen than TIGER/Line
Shapefiles. You can join this file with table data downloaded from American
FactFinder by using the AFFGEOID field in the cartographic boundary file. If
detailed boundaries are required, please use the TIGER/Line Shapefiles instead
of the generalized cartographic boundary files.
}
\references{
\url{https://www2.census.gov/geo/tiger/GENZ2021/}
}
