% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCountryCode.R
\name{getCountryCode}
\alias{getCountryCode}
\title{Return country ISO codes at specified locations}
\usage{
getCountryCode(
  longitude = NULL,
  latitude = NULL,
  datasetName = "SimpleCountriesEEZ",
  countryCodes = NULL,
  allData = FALSE,
  useBuffering = FALSE
)
}
\arguments{
\item{longitude}{Vector of longitudes in decimal degrees East.}

\item{latitude}{Vector of latitudes in decimal degrees North.}

\item{datasetName}{Name of spatial dataset to use.}

\item{countryCodes}{Vector of ISO 3166-1 alpha-2 country codes.}

\item{allData}{Logical specifying whether a full dataframe should be returned.}

\item{useBuffering}{Logical flag specifying the use of location buffering to
find the nearest polygon if no target polygon is found.}
}
\value{
Vector of ISO-3166-1 alpha-2 country codes.
}
\description{
Uses spatial comparison to determine which country polygons the
locations fall into and returns the country code strings for those polygons.

Specification of \code{countryCodes} limits spatial searching to the
specified countries and greatly improves performance.

If \code{allData = TRUE}, additional data is returned.
}
\examples{
library(MazamaSpatialUtils)

longitude <- seq(0, 50)
latitude <- seq(0, 50)

getCountryCode(longitude, latitude)

}
\references{
http://www.naturalearthdata.com/downloads/10m-cultural-vectors/
}
\seealso{
SimpleCountries

getSpatialData
}
\keyword{locator}
