% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlh.R
\name{dlh}
\alias{dlh}
\title{Dayligth hours (N)}
\usage{
dlh(x, lat.rad = NULL, lat.deg = NULL)
}
\arguments{
\item{x}{date-time object or day of the year}

\item{lat.rad}{latitude [rad] (either lat.rad or lat.deg). Latitude is positive for the northern hemisphere and negative for the southern hemisphere}

\item{lat.deg}{latitude [degree] (either lat.rad or lat.deg). Latitude is positive for the northern hemisphere and negative for the southern hemisphere}
}
\description{
Dayligth hours in dependence to latitude.
}
\details{
\describe{\item{x:}{
must be provided as number (1-366) or as a common date-time object (e.g, POSIXct, POSIXlt or Date objects).
All formats for which is.timepoint from the lubridate package returns TRUE can be used}}
}
\note{
eq. 34 of reference
}
\examples{
dlh(x = 105, lat.deg = 13.73)
dlh(x = 105, lat.rad = 0.283)
dlh(x = as.Date('2018-04-15'), lat.deg = 13.73)
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998). Crop evapotranspiration-Guidelines for computing crop water requirements-FAO Irrigation and drainage paper 56. FAO, Rome, 300(9).
}
