% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMeasurementTimings.R
\name{plotMeasurementTimings}
\alias{plotMeasurementTimings}
\title{Plot summariseMeasurementTiming results.}
\usage{
plotMeasurementTimings(
  result,
  y = "time",
  plotType = "boxplot",
  timeScale = "days",
  facet = visOmopResults::strataColumns(result),
  colour = c("cdm_name", "codelist_name")
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{y}{Variable to plot on y axis, it can be "time" or
measurements_per_subject".}

\item{plotType}{Type of plot, either "boxplot" or "densityplot".}

\item{timeScale}{Time scale to show, it can be "days" or "years".}

\item{facet}{Columns to facet by. See options with
`visOmopResults::plotColumns(result)`. Formula input is also allowed to
specify rows and columns.}

\item{colour}{Columns to color by. See options with
`visOmopResults::plotColumns(result)`.}
}
\value{
A ggplot.
}
\description{
Plot summariseMeasurementTiming results.
}
\examples{
\donttest{
library(MeasurementDiagnostics)
cdm <- mockMeasurementDiagnostics()
result <- summariseMeasurementUse(
              cdm = cdm,
              codes = list("test_codelist" = c(3001467L, 45875977L))
           )
result |>
  dplyr::filter(variable_name == "time") |>
  plotMeasurementTimings()
CDMConnector::cdmDisconnect(cdm)
}
}
