% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{class}
\name{Converter}
\alias{Converter}
\title{Converter reference class}
\description{
An object of type Converter is used to efficiently convert data from the
segmental to the genotypic representation. This class has two methods that should be
employed by the user: \code{insert_founder} and \code{convert}. Please look up their
documentation with \code{help(Converter$insert_founder)} and \code{help(Converter$convert)}.
Before starting conversion, all founder alleles and founder genotypes have to be added via
the method \code{insert_founder}. Conversion is then done by the method \code{convert}.

The constructor has two parameters, \code{positions} and \code{use_names}
(optional, defaults to \code{FALSE}).
Parameter \code{positions} must be a list of vectors with the genetic positions.
If these vectors are named, and if \code{use_names} is \code{TRUE},
the result of a conversion via \code{convert} will also be named.

Please see the vignette (\code{vignette('Introduction', package = 'Meiosis')}) for an example.
}
