% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{MRMBE-class}
\alias{MRMBE-class}
\title{MRMBE Class}
\description{
An object containing the estimate produced using the mode-based estimation method of Hartwig et al as well as various statistics.
}
\section{Slots}{

\describe{
\item{\code{Exposure}}{The names of the exposure variables.}

\item{\code{Outcome}}{The name of the outcome variable.}

\item{\code{Weighting}}{Whether the analysis was \code{weighted} or \code{unweighted}.}

\item{\code{StdErr}}{Whether the \code{simple} or \code{delta} version of the standard errors were used.}

\item{\code{Phi}}{The value of the bandwidth factor.}

\item{\code{Estimate}}{The causal estimate from the mode-based estimation method.}

\item{\code{StdError}}{The standard errors associated with \code{Estimate}.}

\item{\code{CILower}}{The lower bounds of the confidence interval for \code{Estimate} based on \code{StdError}.}

\item{\code{CIUpper}}{The upper bounds of the confidence interval for \code{Estimate} based on \code{StdError}.}

\item{\code{Alpha}}{The significance level used in constructing the confidence interval (default is 0.05).}

\item{\code{Pvalue}}{P-value associated with the causal estimate.}

\item{\code{SNPs}}{The number of SNPs that were used in the calculation.}
}}

