% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mr_cML-methods.R
\name{cML_SdTheta}
\alias{cML_SdTheta}
\title{Standard Error of Estimated Theta}
\usage{
cML_SdTheta(b_exp, b_out, se_exp, se_out, theta, b_vec, r_vec)
}
\arguments{
\item{b_exp}{Vector of estimated effects for exposure.}

\item{b_out}{Vector or estimated effects for outcome.}

\item{se_exp}{Vector of standard errors for exposure.}

\item{se_out}{Vector of standard errors for outcome.}

\item{theta}{Estimated theta from cML.}

\item{b_vec}{Estimated vector of b from cML.}

\item{r_vec}{Estimated vector of r from cML.}
}
\value{
Standard error of theta.
}
\description{
Internal function of mr_cML.
Get the standard error of estimated theta from constrained maximum likelihood.
}
\examples{
# First get estimates:
MLE_result = cML_estimate(b_exp = ldlc,b_out = chdlodds,se_exp = ldlcse,
se_out = chdloddsse, K = 5)

# Calculate standard error:
cML_SdTheta(b_exp = ldlc,b_out = chdlodds,se_exp = ldlcse,
se_out = chdloddsse, theta = MLE_result$theta, b_vec = MLE_result$b_vec, r_vec = MLE_result$r_vec)
}
