givemat<-function(name,nl=NULL,ndim=NULL){
	err<-try(M<-eval(parse(text=name),envir=.GlobalEnv),silent=TRUE)
	if(!is.null(attr(err,"condition"))){
		M<-NULL
		ans<-messagebox('Variable not found or wrong syntax !')
	}
	if(!is.null(nl)){
		if(length(M)==nl){
			return(M)
		}else{
			M<-NULL
			ans<-messagebox('Wrong vector length !')
		}
	}
	if(!is.null(ndim)){
		if((nrow(M)==ndim[1])&(ncol(M)==ndim[2])){
			return(M)
		}else{
			M<-NULL
			ans<-messagebox('Wrong matrix dimension !')
		}
	}
	return(M)
}
givedim<-function(v){
	v<-strsplit(unlist(strsplit(v, ',')),':')
	d<-NULL
	for(i in 1:length(v)){
		if(length(v[[i]])==1)d<-c(d,as.numeric(v[[i]]))
		else if(length(v[[i]])==2){
			d<-c(d,as.numeric(v[[i]][1]):as.numeric(v[[i]][2]))
		}else{
			print('Wrong Input Value in Dimension Selection')
		}
	}
	return(d)
}
dovc<-function(d){
	n<-length(d)
	if(is.character(d)){
		C<-factor(d)
		nl<-levels(C)
		n<-nlevels(C)
		if(n<=20){
			vcb<-c(	"black",
					"red",
					"green",
					"blue",
					"brown",
					"cyan",
					"orange",
					"pink",
					"yellow",
					"turquoise",
					"purple",
					"navy",
					"magenta",
					"khaki",
					"ivory",
					"grey",
					"gold",
					"coral",
					"beige",
					"azure")
			Col<-vcb[1:n]
		}else{
		    Col<-rainbow(n)
		}
		C<-as.character(C)
		for(i in 1:n){
			C[C==as.character(nl[i])]<-Col[i]
		}
	}else{
		d<-as.numeric(d) 
		C<-colorpanel(256,low="blue",high="red")[findInterval(d,seq(min(d),max(d),length.out=256))]
	}
return(list(C))
}

messagebox<-function(vlabel){
	table<-gtkTable(rows=5,columns=3,homogeneous=FALSE)
	diag_label<-gtkLabel(vlabel)
	diag_blank<-gtkLabel('      ')
	button_ok<-gtkButton("OK")
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
			button_ok$setData('ans',NULL)
			gtkMainQuit()
		}
	)
	table$attach(diag_label,left.attach=0,1,top.attach=2,3,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_blank,left.attach=0,3,top.attach=3,4,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(button_ok,left.attach=0,3,top.attach=4,5,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Error')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

messageyesno<-function(vlabel){
	table<-gtkTable(rows=5,columns=3,homogeneous=FALSE)
	diag_label<-gtkLabel(vlabel)
	diag_blank<-gtkLabel('      ')
	submit_hbox<-gtkHBox()
	button_yes<-gtkButton("Yes")
	button_no<-gtkButton("No")
	submit_hbox$packStart(button_yes,expand=TRUE)
	submit_hbox$packEnd(button_no,expand=TRUE)
	gSignalConnect(button_yes,"clicked",f=function(button_yes){
		button_yes$setData('ans',list('TRUE'))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_no,"clicked",f=function(button_no){
		button_yes$setData('ans',list('FALSE'))
		gtkMainQuit()
		}
	)
	table$attach(diag_label,left.attach=0,1,top.attach=2,3,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_blank,left.attach=0,3,top.attach=3,4,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,3,top.attach=4,5,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Question')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_yes$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe1<-function(vlabel,inp){
	table<-gtkTable(rows=3,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entrygp<-list()
	entrygp$t1<-gtkEntryNew()
	entrygp$t1$setText(inp[1])
	sapply(entrygp,diag_entry$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entrygp$t1$getText()))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_entry)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_label)
	table$attach(diag_align1,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,3,top.attach=2,3,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe2<-function(vlabel,inp){
	table<-gtkTable(rows=3,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entrygp<-list()
	entrygp$t1<-gtkEntryNew()
	entrygp$t1$setText(inp[1])
	entrygp$t2<-gtkEntryNew()
	entrygp$t2$setText(inp[2])
	sapply(entrygp,diag_entry$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entrygp$t1$getText(),entrygp$t2$getText()))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_entry)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_label)
	table$attach(diag_align1,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,3,top.attach=2,3,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe3<-function(vlabel,inp){
	table<-gtkTable(rows=3,columns=2,homogeneous=FALSE)
	label<-gtkLabel(vlabel[1])
	entry<-gtkEntryNew()
	entry$setText(inp[1])
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[2])
	labelgp$t2<-gtkLabel(vlabel[3])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entrygp<-list()
	entrygp$t1<-gtkEntryNew()
	entrygp$t1$setText(inp[2])
	entrygp$t2<-gtkEntryNew()
	entrygp$t2$setText(inp[3])
	sapply(entrygp,diag_entry$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entry$getText(),entrygp$t1$getText(),entrygp$t2$getText()))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	label['xalign']<-1
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_entry)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_label)
	table$attach(label,left.attach=0,1,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(entry,left.attach=1,2,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,3,top.attach=2,3,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe4<-function(vlabel,inp){
	table<-gtkTable(rows=5,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	labelgp$t4<-gtkLabel(vlabel[4])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entry1<-gtkEntryNew()
	entry1$SetText(inp[1])
	entry2<-gtkEntryNew()
	entry2$SetText(inp[2])
	entry3<-gtkEntryNew()
	entry3$SetText(inp[3])
	entry4<-gtkEntryNew()
	entry4$SetText(inp[4])
	diag_entry$packStart(entry1)
	diag_entry$packStart(entry2)
	diag_entry$packStart(entry3)
	diag_entry$packStart(entry4)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entry1$getText(),
								entry2$getText(),
								entry3$getText(),
								entry4$getText()))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_label)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_entry)
	table$attach(diag_align,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,3,top.attach=5,6,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe5<-function(vlabel,inp){
	table<-gtkTable(rows=7,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	labelgp$t4<-gtkLabel(vlabel[4])
	labelgp$t5<-gtkLabel(vlabel[5])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entry1<-gtkEntryNew()
	entry1$SetText(inp[1])
	entry2<-gtkEntryNew()
	entry2$SetText(inp[2])
	entry3<-gtkEntryNew()
	entry3$SetText(inp[3])
	entry4<-gtkEntryNew()
	entry4$SetText(inp[4])
	entry5<-gtkEntryNew()
	entry5$SetText(inp[5])
	diag_entry$packStart(entry1)
	diag_entry$packStart(entry2)
	diag_entry$packStart(entry3)
	diag_entry$packStart(entry4)
	diag_entry$packStart(entry5)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entry1$getText(),
								entry2$getText(),
								entry3$getText(),
								entry4$getText(),
								entry5$getText()))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_label)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_entry)
	table$attach(diag_align,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,3,top.attach=6,7,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxc<-function(vlabel,vcombo,inp=1){
	table<-gtkTable(rows=3,columns=2,homogeneous=FALSE)
	label<-gtkLabel(vlabel)
	combo<-gtkComboBoxNewText()
	sapply(vcombo,combo$appendText)
	combo$setActive(inp)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(as.integer(combo$getActive())+1))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	label['xalign']<-1
	table$attach(label,left.attach=0,1,top.attach=0,1,xoptions=c('expand','fill'),yoptions='')
	table$attach(combo,left.attach=1,2,top.attach=0,1,xoptions='fill',yoptions='')
	table$attach(submit_hbox,left.attach=0,3,top.attach=2,3,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxc2<-function(vlabel,vcombo1,vcombo2,inp=c(1,1)){
	table<-gtkTable(rows=3,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	sapply(labelgp,diag_label$packStart)
	diag_combo<-gtkVBox()
	combogp<-list()
	combogp$t1<-gtkComboBoxNewText()
	sapply(vcombo1,combogp$t1$appendText)
	combogp$t1$setActive(inp[1])
	combogp$t2<-gtkComboBoxNewText()
	sapply(vcombo2,combogp$t2$appendText)
	combogp$t2$setActive(inp[2])
	sapply(combogp,diag_combo$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(as.integer(combogp$t1$getActive())+1,
								as.integer(combogp$t2$getActive())+1))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_label)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_combo)
	table$attach(diag_align,left.attach=0,1,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=1,2,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,3,top.attach=2,3,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxec<-function(vlabel,vcombo,inp){
	table<-gtkTable(rows=6,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entry<-gtkEntryNew()
	entry$setText(inp)
	combo<-gtkComboBoxNewText()
	sapply(vcombo,combo$appendText)
	diag_entry$packStart(entry)
	diag_entry$packStart(combo)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entry$getText(),combo$getActive()+1))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_label)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_entry)
	table$attach(diag_align,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=1,2,top.attach=1,2,xoptions='',yoptions='')
	table$attach(submit_hbox,left.attach=0,3,top.attach=5,6,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe2c<-function(vlabel,vcombo,inp){
	table<-gtkTable(rows=5,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entry1<-gtkEntryNew()
	entry1$SetText(inp[1])
	combo1<-gtkComboBoxNewText()
	sapply(vcombo,combo1$appendText)
	combo1$SetActive(as.integer(inp[4]))
	entry2<-gtkEntryNew()
	entry2$SetText(inp[2])
	diag_entry$packStart(entry1)
	diag_entry$packStart(entry2)
	diag_entry$packStart(combo1)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entry1$getText(),
								entry2$getText(),
								combo1$getActive()+1))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_label)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_entry)
	table$attach(diag_align,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=1,2,top.attach=1,2,xoptions='',yoptions='')
	table$attach(submit_hbox,left.attach=0,3,top.attach=5,6,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe3c<-function(vlabel,vcombo,inp){
	table<-gtkTable(rows=5,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	labelgp$t4<-gtkLabel(vlabel[4])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entry1<-gtkEntryNew()
	entry1$SetText(inp[1])
	combo1<-gtkComboBoxNewText()
	sapply(vcombo,combo1$appendText)
	combo1$SetActive(as.integer(inp[5]))
	entry2<-gtkEntryNew()
	entry2$SetText(inp[2])
	entry3<-gtkEntryNew()
	entry3$SetText(inp[3])
	diag_entry$packStart(entry1)
	diag_entry$packStart(entry2)
	diag_entry$packStart(entry3)
	diag_entry$packStart(combo1)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entry1$getText(),
								entry2$getText(),
								entry3$getText(),
								combo1$getActive()+1))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_label)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_entry)
	table$attach(diag_align,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=1,2,top.attach=1,2,xoptions='',yoptions='')
	table$attach(submit_hbox,left.attach=0,3,top.attach=5,6,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxek2<-function(vlabel,inp){
	table<-gtkTable(rows=3,columns=2,homogeneous=FALSE)
	label<-gtkLabel(vlabel[1])
	entry<-gtkEntryNew()
	entry$setText(inp[1])
	diag_label<-gtkLabel(vlabel[2])
	diag_check<-gtkHBox()
	checkgp<-list()
	checkgp$t1<-gtkCheckButtonNewWithLabel(label=vlabel[3])
	checkgp$t2<-gtkCheckButtonNewWithLabel(label=vlabel[4])
	checkgp$t1$SetActive(inp[2])
	checkgp$t2$SetActive(inp[3])
	sapply(checkgp,diag_check$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entry$getText(),
								gtkToggleButtonGetActive(checkgp$t1),
								gtkToggleButtonGetActive(checkgp$t2)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	label['xalign']<-1
	diag_label['xalign']<-1
	diag_label['yalign']<-0
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_check)
	table$attach(label,left.attach=0,1,top.attach=0,1,xoptions=c('expand','fill'),yoptions='')
	table$attach(entry,left.attach=1,2,top.attach=0,1,xoptions='fill',yoptions='')
	table$attach(diag_label,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions='')
	table$attach(submit_hbox,left.attach=0,2,top.attach=2,3,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxer3<-function(vlabel,inp){
	table<-gtkTable(rows=5,columns=2,homogeneous=FALSE)
	label<-gtkLabel(vlabel[1])
	entry<-gtkEntryNew()
	entry$setText(inp[1])
	diag_label<-gtkLabel(vlabel[2])
	diag_radio<-gtkVBox()
	radiogp<-list()
	radiogp$t1<-gtkRadioButtonNewWithLabel(group=NULL,label=vlabel[3])
	radiogp$t2<-gtkRadioButtonNewWithLabelFromWidget(group=radiogp$t1,label=vlabel[4])
	radiogp$t3<-gtkRadioButtonNewWithLabelFromWidget(group=radiogp$t1,label=vlabel[5])
	sapply(radiogp,diag_radio$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entry$getText(),
								gtkToggleButtonGetActive(radiogp$t1),
								gtkToggleButtonGetActive(radiogp$t2),
								gtkToggleButtonGetActive(radiogp$t3)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	table$attach(label,left.attach=0,1,top.attach=0,1,xoptions=c('expand','fill'),yoptions='')
	table$attach(entry,left.attach=1,2,top.attach=0,1,xoptions='fill',yoptions='')
	table$attach(diag_label,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_radio,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,5,top.attach=2,5,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe2k2<-function(vlabel,inp){
	table<-gtkTable(rows=3,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entrygp<-list()
	entrygp$t1<-gtkEntryNew()
	entrygp$t2<-gtkEntryNew()
	entrygp$t1$setText(inp[1])
	entrygp$t2$setText(inp[2])
	sapply(entrygp,diag_entry$packStart)
	diag_check<-gtkHBox()
	checkgp<-list()
	checkgp$t1<-gtkCheckButtonNewWithLabel(label=vlabel[3])
	checkgp$t2<-gtkCheckButtonNewWithLabel(label=vlabel[4])
	checkgp$t1$SetActive(as.logical(inp[3]))
	checkgp$t2$SetActive(as.logical(inp[4]))
	sapply(checkgp,diag_check$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entrygp$t1$getText(),
								entrygp$t2$getText(),
								gtkToggleButtonGetActive(checkgp$t1),
								gtkToggleButtonGetActive(checkgp$t2)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_check)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_label)
	diag_align2<-gtkAlignment(xalign=0)
	diag_align2$add(diag_entry)
	table$attach(diag_align1,left.attach=0,1,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align2,left.attach=1,2,top.attach=0,1,xoptions='fill',yoptions=c('expand','fill'))
	table$attach(diag_align,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions='')
	table$attach(submit_hbox,left.attach=0,2,top.attach=2,3,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe2k<-function(vlabel,inp){
	table<-gtkTable(rows=3,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entrygp<-list()
	entrygp$t1<-gtkEntryNew()
	entrygp$t2<-gtkEntryNew()
	entrygp$t1$setText(inp[1])
	entrygp$t2$setText(inp[2])
	sapply(entrygp,diag_entry$packStart)
	diag_check<-gtkHBox()
	checkgp<-list()
	checkgp$t1<-gtkCheckButtonNewWithLabel(label=vlabel[3])
	checkgp$t1$SetActive(as.logical(inp[3]))
	sapply(checkgp,diag_check$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entrygp$t1$getText(),
								entrygp$t2$getText(),
								gtkToggleButtonGetActive(checkgp$t1)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_check)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_label)
	diag_align2<-gtkAlignment(xalign=0)
	diag_align2$add(diag_entry)
	table$attach(diag_align1,left.attach=0,1,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align2,left.attach=1,2,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,2,top.attach=2,3,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe3k<-function(vlabel,inp){
	table<-gtkTable(rows=4,columns=2,homogeneous=FALSE)	
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entrygp<-list()
	entrygp$t1<-gtkEntryNew()
	entrygp$t2<-gtkEntryNew()
	entrygp$t3<-gtkEntryNew()
	entrygp$t1$setText(inp[1])
	entrygp$t2$setText(inp[2])
	entrygp$t3$setText(inp[3])
	sapply(entrygp,diag_entry$packStart)
	diag_check<-gtkHBox()
	checkgp<-list()
	checkgp$t1<-gtkCheckButtonNewWithLabel(label=vlabel[4])
	checkgp$t1$SetActive(as.logical(inp[4]))
	sapply(checkgp,diag_check$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entrygp$t1$getText(),
								entrygp$t2$getText(),
								entrygp$t3$getText(),
								gtkToggleButtonGetActive(checkgp$t1)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_check)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_label)
	diag_align2<-gtkAlignment(xalign=0)
	diag_align2$add(diag_entry)
	table$attach(diag_align1,left.attach=0,1,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align2,left.attach=1,2,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align,left.attach=1,2,top.attach=2,3,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,2,top.attach=3,4,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe3k2<-function(vlabel,inp){
	table<-gtkTable(rows=5,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entrygp<-list()
	entrygp$t1<-gtkEntryNew()
	entrygp$t2<-gtkEntryNew()
	entrygp$t3<-gtkEntryNew()
	entrygp$t1$setText(inp[1])
	entrygp$t2$setText(inp[2])
	entrygp$t3$setText(inp[3])
	sapply(entrygp,diag_entry$packStart)
	diag_check<-gtkHBox()
	checkgp<-list()
	checkgp$t1<-gtkCheckButtonNewWithLabel(label=vlabel[4])
	checkgp$t2<-gtkCheckButtonNewWithLabel(label=vlabel[5])
	checkgp$t1$SetActive(as.logical(inp[4]))
	checkgp$t2$SetActive(as.logical(inp[5]))
	sapply(checkgp,diag_check$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entrygp$t1$getText(),
								entrygp$t2$getText(),
								entrygp$t3$getText(),
								gtkToggleButtonGetActive(checkgp$t1),
								gtkToggleButtonGetActive(checkgp$t2)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_check)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_label)
	diag_align2<-gtkAlignment(xalign=0)
	diag_align2$add(diag_entry)
	table$attach(diag_align1,left.attach=0,1,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align2,left.attach=1,2,top.attach=0,3,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align,left.attach=1,2,top.attach=3,4,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,2,top.attach=4,5,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe3k3<-function(vlabel,inp){
	table<-gtkTable(rows=6,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entry1<-gtkEntryNew()
	entry1$SetText(inp[1])
	entry2<-gtkEntryNew()
	entry2$SetText(inp[2])
	entry3<-gtkEntryNew()
	entry3$SetText(inp[3])
	diag_entry$packStart(entry1)
	diag_entry$packStart(entry2)
	diag_entry$packStart(entry3)
	diag_check<-gtkHBox()
	checkgp<-list()
	checkgp$t1<-gtkCheckButtonNewWithLabel(label=vlabel[4])
	checkgp$t1$SetActive(as.logical(inp[4]))
	checkgp$t2<-gtkCheckButtonNewWithLabel(label=vlabel[5])
	checkgp$t2$SetActive(as.logical(inp[5]))
	checkgp$t3<-gtkCheckButtonNewWithLabel(label=vlabel[6])
	checkgp$t3$SetActive(as.logical(inp[6]))
	sapply(checkgp,diag_check$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entry1$getText(),
								entry2$getText(),
								entry3$getText(),
								gtkToggleButtonGetActive(checkgp$t1),
								gtkToggleButtonGetActive(checkgp$t2),
								gtkToggleButtonGetActive(checkgp$t3)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_label)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_entry)
	table$attach(diag_align,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_check,left.attach=1,2,top.attach=5,6,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,3,top.attach=6,7,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe4k<-function(vlabel,inp){
	table<-gtkTable(rows=5,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	labelgp$t4<-gtkLabel(vlabel[4])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entrygp<-list()
	entrygp$t1<-gtkEntryNew()
	entrygp$t2<-gtkEntryNew()
	entrygp$t3<-gtkEntryNew()
	entrygp$t4<-gtkEntryNew()
	entrygp$t1$setText(inp[1])
	entrygp$t2$setText(inp[2])
	entrygp$t3$setText(inp[3])
	entrygp$t4$setText(inp[4])
	sapply(entrygp,diag_entry$packStart)
	diag_check<-gtkHBox()
	checkgp<-list()
	checkgp$t1<-gtkCheckButtonNewWithLabel(label=vlabel[5])
	checkgp$t1$SetActive(as.logical(inp[5]))
	sapply(checkgp,diag_check$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entrygp$t1$getText(),
								entrygp$t2$getText(),
								entrygp$t3$getText(),
								entrygp$t4$getText(),
								gtkToggleButtonGetActive(checkgp$t1)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_check)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_label)
	diag_align2<-gtkAlignment(xalign=0)
	diag_align2$add(diag_entry)
	table$attach(diag_align1,left.attach=0,1,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align2,left.attach=1,2,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align,left.attach=1,2,top.attach=2,3,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,2,top.attach=4,5,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe4k2<-function(vlabel,inp){
	table<-gtkTable(rows=7,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	labelgp$t4<-gtkLabel(vlabel[4])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entry1<-gtkEntryNew()
	entry1$SetText(inp[1])
	entry2<-gtkEntryNew()
	entry2$SetText(inp[2])
	entry3<-gtkEntryNew()
	entry3$SetText(inp[3])
	entry4<-gtkEntryNew()
	entry4$SetText(inp[4])
	entry5<-gtkEntryNew()
	entry5$SetText(inp[5])
	diag_entry$packStart(entry1)
	diag_entry$packStart(entry2)
	diag_entry$packStart(entry3)
	diag_entry$packStart(entry4)
	diag_check<-gtkVBox()
	checkgp<-list()
	checkgp$t1<-gtkCheckButtonNewWithLabel(label=vlabel[5])
	checkgp$t1$SetActive(as.logical(inp[5]))
	checkgp$t2<-gtkCheckButtonNewWithLabel(label=vlabel[6])
	checkgp$t2$SetActive(as.logical(inp[6]))
	sapply(checkgp,diag_check$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entry1$getText(),
								entry2$getText(),
								entry3$getText(),
								entry4$getText(),
								gtkToggleButtonGetActive(checkgp$t1),
								gtkToggleButtonGetActive(checkgp$t2)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_label)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_entry)
	table$attach(diag_align,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_check,left.attach=1,2,top.attach=5,6,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,3,top.attach=6,7,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe4k3<-function(vlabel,inp){
	table<-gtkTable(rows=7,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	labelgp$t4<-gtkLabel(vlabel[4])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entry1<-gtkEntryNew()
	entry1$SetText(inp[1])
	entry2<-gtkEntryNew()
	entry2$SetText(inp[2])
	entry3<-gtkEntryNew()
	entry3$SetText(inp[3])
	entry4<-gtkEntryNew()
	entry4$SetText(inp[4])
	diag_entry$packStart(entry1)
	diag_entry$packStart(entry2)
	diag_entry$packStart(entry3)
	diag_entry$packStart(entry4)
	diag_check<-gtkHBox()
	checkgp<-list()
	checkgp$t1<-gtkCheckButtonNewWithLabel(label=vlabel[5])
	checkgp$t1$SetActive(as.logical(inp[5]))
	checkgp$t2<-gtkCheckButtonNewWithLabel(label=vlabel[6])
	checkgp$t2$SetActive(as.logical(inp[6]))
	checkgp$t3<-gtkCheckButtonNewWithLabel(label=vlabel[7])
	checkgp$t3$SetActive(as.logical(inp[7]))
	sapply(checkgp,diag_check$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entry1$getText(),
								entry2$getText(),
								entry3$getText(),
								entry4$getText(),
								gtkToggleButtonGetActive(checkgp$t1),
								gtkToggleButtonGetActive(checkgp$t2),
								gtkToggleButtonGetActive(checkgp$t3)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_label)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_entry)
	table$attach(diag_align,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_check,left.attach=1,2,top.attach=5,6,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,3,top.attach=6,7,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe5k3<-function(vlabel,inp,dis=FALSE){
	table<-gtkTable(rows=7,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	labelgp$t4<-gtkLabel(vlabel[4])
	labelgp$t5<-gtkLabel(vlabel[5])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entry1<-gtkEntryNew()
	entry1$SetText(inp[1])
	entry2<-gtkEntryNew()
	entry2$SetText(inp[2])
	entry3<-gtkEntryNew()
	entry3$SetText(inp[3])
	entry4<-gtkEntryNew()
	entry4$SetText(inp[4])
	entry5<-gtkEntryNew()
	entry5$SetText(inp[5])
	diag_entry$packStart(entry1)
	diag_entry$packStart(entry2)
	diag_entry$packStart(entry3)
	diag_entry$packStart(entry4)
	diag_entry$packStart(entry5)
	diag_check<-gtkHBox()
	checkgp<-list()
	checkgp$t1<-gtkCheckButtonNewWithLabel(label=vlabel[6])
	checkgp$t1$SetActive(as.logical(inp[6]))
	if(dis)checkgp$t1$SetSensitive(FALSE)
	checkgp$t2<-gtkCheckButtonNewWithLabel(label=vlabel[7])
	checkgp$t2$SetActive(as.logical(inp[7]))
	checkgp$t3<-gtkCheckButtonNewWithLabel(label=vlabel[8])
	checkgp$t3$SetActive(as.logical(inp[8]))
	sapply(checkgp,diag_check$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entry1$getText(),
								entry2$getText(),
								entry3$getText(),
								entry4$getText(),
								entry5$getText(),
								gtkToggleButtonGetActive(checkgp$t1),
								gtkToggleButtonGetActive(checkgp$t2),
								gtkToggleButtonGetActive(checkgp$t3)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_label)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_entry)
	table$attach(diag_align,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_check,left.attach=1,2,top.attach=5,6,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,3,top.attach=6,7,xoptions=c('expand','fill'),yoptions=c('expand','fill'))	
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe5k2<-function(vlabel,inp){
	table<-gtkTable(rows=7,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	labelgp$t4<-gtkLabel(vlabel[4])
	labelgp$t5<-gtkLabel(vlabel[5])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entrygp<-list()
	entrygp$t1<-gtkEntryNew()
	entrygp$t2<-gtkEntryNew()
	entrygp$t3<-gtkEntryNew()
	entrygp$t4<-gtkEntryNew()
	entrygp$t5<-gtkEntryNew()
	entrygp$t1$setText(inp[1])
	entrygp$t2$setText(inp[2])
	entrygp$t3$setText(inp[3])
	entrygp$t4$setText(inp[4])
	entrygp$t5$setText(inp[5])
	sapply(entrygp,diag_entry$packStart)
	diag_check<-gtkHBox()
	checkgp<-list()
	checkgp$t1<-gtkCheckButtonNewWithLabel(label=vlabel[6])
	checkgp$t2<-gtkCheckButtonNewWithLabel(label=vlabel[7])
	checkgp$t1$SetActive(as.logical(inp[6]))
	checkgp$t2$SetActive(as.logical(inp[7]))
	sapply(checkgp,diag_check$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entrygp$t1$getText(),
								entrygp$t2$getText(),
								entrygp$t3$getText(),
								entrygp$t4$getText(),
								entrygp$t5$getText(),
								gtkToggleButtonGetActive(checkgp$t1),
								gtkToggleButtonGetActive(checkgp$t2)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_check)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_label)
	diag_align2<-gtkAlignment(xalign=0)
	diag_align2$add(diag_entry)
	table$attach(diag_align1,left.attach=0,1,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align2,left.attach=1,2,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,2,top.attach=7,8,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe6k2<-function(vlabel,inp){
	table<-gtkTable(rows=8,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	labelgp$t4<-gtkLabel(vlabel[4])
	labelgp$t5<-gtkLabel(vlabel[5])
	labelgp$t6<-gtkLabel(vlabel[6])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entrygp<-list()
	entrygp$t1<-gtkEntryNew()
	entrygp$t2<-gtkEntryNew()
	entrygp$t3<-gtkEntryNew()
	entrygp$t4<-gtkEntryNew()
	entrygp$t5<-gtkEntryNew()
	entrygp$t6<-gtkEntryNew()
	entrygp$t1$setText(inp[1])
	entrygp$t2$setText(inp[2])
	entrygp$t3$setText(inp[3])
	entrygp$t4$setText(inp[4])
	entrygp$t5$setText(inp[5])
	entrygp$t6$setText(inp[6])
	sapply(entrygp,diag_entry$packStart)
	diag_check<-gtkHBox()
	checkgp<-list()
	checkgp$t1<-gtkCheckButtonNewWithLabel(label=vlabel[7])
	checkgp$t2<-gtkCheckButtonNewWithLabel(label=vlabel[8])
	checkgp$t1$SetActive(as.logical(inp[7]))
	checkgp$t2$SetActive(as.logical(inp[8]))
	sapply(checkgp,diag_check$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entrygp$t1$getText(),
								entrygp$t2$getText(),
								entrygp$t3$getText(),
								entrygp$t4$getText(),
								entrygp$t5$getText(),
								entrygp$t6$getText(),
								gtkToggleButtonGetActive(checkgp$t1),
								gtkToggleButtonGetActive(checkgp$t2)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_check)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_label)
	diag_align2<-gtkAlignment(xalign=0)
	diag_align2$add(diag_entry)
	table$attach(diag_align1,left.attach=0,1,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align2,left.attach=1,2,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,2,top.attach=7,8,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe6k3<-function(vlabel,inp,dis=FALSE){
	table<-gtkTable(rows=8,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	labelgp$t4<-gtkLabel(vlabel[4])
	labelgp$t5<-gtkLabel(vlabel[5])
	labelgp$t6<-gtkLabel(vlabel[6])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entry1<-gtkEntryNew()
	entry1$SetText(inp[1])
	entry2<-gtkEntryNew()
	entry2$SetText(inp[2])
	entry3<-gtkEntryNew()
	entry3$SetText(inp[3])
	entry4<-gtkEntryNew()
	entry4$SetText(inp[4])
	entry5<-gtkEntryNew()
	entry5$SetText(inp[5])
	entry6<-gtkEntryNew()
	entry6$SetText(inp[6])
	diag_entry$packStart(entry1)
	diag_entry$packStart(entry2)
	diag_entry$packStart(entry3)
	diag_entry$packStart(entry4)
	diag_entry$packStart(entry5)
	diag_entry$packStart(entry6)
	diag_check<-gtkHBox()
	checkgp<-list()
	checkgp$t1<-gtkCheckButtonNewWithLabel(label=vlabel[7])
	checkgp$t1$SetActive(as.logical(inp[7]))
	if(dis)checkgp$t1$SetSensitive(FALSE)
	checkgp$t2<-gtkCheckButtonNewWithLabel(label=vlabel[8])
	checkgp$t2$SetActive(as.logical(inp[8]))
	checkgp$t3<-gtkCheckButtonNewWithLabel(label=vlabel[9])
	checkgp$t3$SetActive(as.logical(inp[9]))
	sapply(checkgp,diag_check$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entry1$getText(),
								entry2$getText(),
								entry3$getText(),
								entry4$getText(),
								entry5$getText(),
								entry6$getText(),
								gtkToggleButtonGetActive(checkgp$t1),
								gtkToggleButtonGetActive(checkgp$t2),
								gtkToggleButtonGetActive(checkgp$t3)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_label)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_entry)
	table$attach(diag_align,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_check,left.attach=1,2,top.attach=6,7,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,3,top.attach=7,8,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe7k2<-function(vlabel,inp){
	table<-gtkTable(rows=10,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	labelgp$t4<-gtkLabel(vlabel[4])
	labelgp$t5<-gtkLabel(vlabel[5])
	labelgp$t6<-gtkLabel(vlabel[6])
	labelgp$t7<-gtkLabel(vlabel[7])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entry1<-gtkEntryNew()
	entry1$SetText(inp[1])
	entry2<-gtkEntryNew()
	entry2$SetText(inp[2])
	entry3<-gtkEntryNew()
	entry3$SetText(inp[3])
	entry4<-gtkEntryNew()
	entry4$SetText(inp[4])
	entry5<-gtkEntryNew()
	entry5$SetText(inp[5])
	entry6<-gtkEntryNew()
	entry6$SetText(inp[6])
	entry7<-gtkEntryNew()
	entry7$SetText(inp[7])
	diag_entry$packStart(entry1)
	diag_entry$packStart(entry2)
	diag_entry$packStart(entry3)
	diag_entry$packStart(entry4)
	diag_entry$packStart(entry5)
	diag_entry$packStart(entry6)
	diag_entry$packStart(entry7)
	diag_check<-gtkHBox()
	checkgp<-list()
	checkgp$t1<-gtkCheckButtonNewWithLabel(label=vlabel[8])
	checkgp$t2<-gtkCheckButtonNewWithLabel(label=vlabel[9])
	checkgp$t1$SetActive(as.logical(inp[8]))
	checkgp$t2$SetActive(as.logical(inp[9]))
	sapply(checkgp,diag_check$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entry1$getText(),
								entry2$getText(),
								entry3$getText(),
								entry4$getText(),
								entry5$getText(),
								entry6$getText(),
								entry7$getText(),
								gtkToggleButtonGetActive(checkgp$t1),
								gtkToggleButtonGetActive(checkgp$t2)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_label)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_entry)
	diag_align2<-gtkAlignment(xalign=0)
	diag_align2$add(diag_check)
	table$attach(diag_align,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align2,left.attach=1,2,top.attach=7,8,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,3,top.attach=8,9,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxr2<-function(vlabel,inp){
	table<-gtkTable(rows=2,columns=2,homogeneous=FALSE)
	diag_label<-gtkLabel(vlabel[1])
	diag_radio<-gtkVBox()
	radiogp<-list()
	radiogp$t1<-gtkRadioButtonNewWithLabel(group=NULL,label=vlabel[2])
	radiogp$t1$SetActive(as.logical(inp[1]))
	radiogp$t2<-gtkRadioButtonNewWithLabelFromWidget(group=radiogp$t1,label=vlabel[3])
	radiogp$t2$SetActive(as.logical(inp[2]))
	sapply(radiogp,diag_radio$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(gtkToggleButtonGetActive(radiogp$t1),
									gtkToggleButtonGetActive(radiogp$t2)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	table$attach(diag_label,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_radio,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,3,top.attach=2,3,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe2r2<-function(vlabel,inp){
	table<-gtkTable(rows=3,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entrygp<-list()
	entrygp$t1<-gtkEntryNew()
	entrygp$t2<-gtkEntryNew()
	entrygp$t1$setText(inp[1])
	entrygp$t2$setText(inp[2])
	sapply(entrygp,diag_entry$packStart)
	diag_radio<-gtkVBox()
	radiogp<-list()
	radiogp$t1<-gtkRadioButtonNewWithLabel(group=NULL,label=vlabel[3])
	radiogp$t2<-gtkRadioButtonNewWithLabelFromWidget(group=radiogp$t1,label=vlabel[4])
	sapply(radiogp,diag_radio$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entrygp$t1$getText(),
								entrygp$t2$getText(),
								gtkToggleButtonGetActive(radiogp$t1),
								gtkToggleButtonGetActive(radiogp$t2)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_radio)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_label)
	diag_align2<-gtkAlignment(xalign=0)
	diag_align2$add(diag_entry)
	table$attach(diag_align1,left.attach=0,1,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align2,left.attach=1,2,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,2,top.attach=2,3,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe4r2<-function(vlabel,inp){
	table<-gtkTable(rows=5,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	labelgp$t4<-gtkLabel(vlabel[4])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entrygp<-list()
	entrygp$t1<-gtkEntryNew()
	entrygp$t2<-gtkEntryNew()
	entrygp$t3<-gtkEntryNew()
	entrygp$t4<-gtkEntryNew()
	entrygp$t1$setText(inp[1])
	entrygp$t2$setText(inp[2])
	entrygp$t3$setText(inp[3])
	entrygp$t4$setText(inp[4])
	sapply(entrygp,diag_entry$packStart)
	diag_radio<-gtkHBox()
	radiogp<-list()
	radiogp$t1<-gtkRadioButtonNewWithLabel(group=NULL,label=vlabel[5])
	radiogp$t2<-gtkRadioButtonNewWithLabelFromWidget(group=radiogp$t1,label=vlabel[6])
	sapply(radiogp,diag_radio$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entrygp$t1$getText(),
								entrygp$t2$getText(),
								entrygp$t3$getText(),
								entrygp$t4$getText(),
								gtkToggleButtonGetActive(radiogp$t1),
								gtkToggleButtonGetActive(radiogp$t2)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_radio)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_label)
	diag_align2<-gtkAlignment(xalign=0)
	diag_align2$add(diag_entry)
	table$attach(diag_align1,left.attach=0,1,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align2,left.attach=1,2,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align,left.attach=1,2,top.attach=2,3,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,2,top.attach=4,5,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe4c2<-function(vlabel,vcombo1,vcombo2,inp){
	table<-gtkTable(rows=7,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	labelgp$t4<-gtkLabel(vlabel[4])
	labelgp$t5<-gtkLabel(vlabel[5])
	labelgp$t6<-gtkLabel(vlabel[6])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entry1<-gtkEntryNew()
	entry1$SetText(inp[1])
	entry2<-gtkEntryNew()
	entry2$SetText(inp[2])
	entry3<-gtkEntryNew()
	entry3$SetText(inp[3])
	entry4<-gtkEntryNew()
	entry4$SetText(inp[4])
	combo1<-gtkComboBoxNewText()
	sapply(vcombo1,combo1$appendText)
	combo2<-gtkComboBoxNewText()
	sapply(vcombo2,combo2$appendText)
	combo1$SetActive(as.integer(inp[5]))
	combo2$SetActive(as.integer(inp[6]))
	diag_entry$packStart(entry1)
	diag_entry$packStart(entry2)
	diag_entry$packStart(entry3)
	diag_entry$packStart(entry4)
	diag_entry$packStart(combo1)
	diag_entry$packStart(combo2)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entry1$getText(),
								entry2$getText(),
								entry3$getText(),
								entry4$getText(),
								combo1$getActive()+1,
								combo2$getActive()+1))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_label)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_entry)
	table$attach(diag_align,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=1,2,top.attach=1,2,xoptions='',yoptions='')
	table$attach(submit_hbox,left.attach=0,3,top.attach=5,6,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe4ck<-function(vlabel,vcombo,inp){
	table<-gtkTable(rows=7,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	labelgp$t4<-gtkLabel(vlabel[4])
	labelgp$t5<-gtkLabel(vlabel[5])
	labelgp$t6<-gtkLabel(vlabel[6])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entry1<-gtkEntryNew()
	entry1$SetText(inp[1])
	entry2<-gtkEntryNew()
	entry2$SetText(inp[2])
	entry3<-gtkEntryNew()
	entry3$SetText(inp[3])
	entry4<-gtkEntryNew()
	entry4$SetText(inp[4])
	combo<-gtkComboBoxNewText()
	sapply(vcombo,combo$appendText)
	combo$SetActive(as.integer(inp[5]))
	check<-gtkCheckButtonNewWithLabel(label='')
	check$SetActive(as.logical(inp[6]))
	diag_entry$packStart(entry1)
	diag_entry$packStart(entry2)
	diag_entry$packStart(entry3)
	diag_entry$packStart(entry4)
	diag_entry$packStart(combo)
	diag_entry$packStart(check)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entry1$getText(),
								entry2$getText(),
								entry3$getText(),
								entry4$getText(),
								combo$getActive()+1,
								gtkToggleButtonGetActive(check)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_label)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_entry)
	table$attach(diag_align,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,3,top.attach=5,6,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe4c2k<-function(vlabel,vcombo1,vcombo2,inp){
	table<-gtkTable(rows=8,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	labelgp$t4<-gtkLabel(vlabel[4])
	labelgp$t5<-gtkLabel(vlabel[5])
	labelgp$t6<-gtkLabel(vlabel[6])
	labelgp$t7<-gtkLabel(vlabel[7])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entry1<-gtkEntryNew()
	entry1$SetText(inp[1])
	entry2<-gtkEntryNew()
	entry2$SetText(inp[2])
	entry3<-gtkEntryNew()
	entry3$SetText(inp[3])
	entry4<-gtkEntryNew()
	entry4$SetText(inp[4])
	combo1<-gtkComboBoxNewText()
	sapply(vcombo1,combo1$appendText)
	combo2<-gtkComboBoxNewText()
	sapply(vcombo2,combo2$appendText)
	combo1$SetActive(as.integer(inp[5]))
	combo2$SetActive(as.integer(inp[6]))
	check1<-gtkCheckButtonNewWithLabel(label='')
	check1$SetActive(as.logical(inp[7]))
	diag_entry$packStart(entry1)
	diag_entry$packStart(entry2)
	diag_entry$packStart(entry3)
	diag_entry$packStart(entry4)
	diag_entry$packStart(combo1)
	diag_entry$packStart(combo2)
	diag_entry$packStart(check1)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entry1$getText(),
								entry2$getText(),
								entry3$getText(),
								entry4$getText(),
								combo1$getActive()+1,
								combo2$getActive()+1),
								gtkToggleButtonGetActive(check1))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_label)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_entry)
	table$attach(diag_align,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,3,top.attach=5,6,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe6r2<-function(vlabel,inp){
	table<-gtkTable(rows=10,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	labelgp$t4<-gtkLabel(vlabel[4])
	labelgp$t5<-gtkLabel(vlabel[5])
	labelgp$t6<-gtkLabel(vlabel[6])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entry1<-gtkEntryNew()
	entry1$SetText(inp[1])
	entry2<-gtkEntryNew()
	entry2$SetText(inp[2])
	entry3<-gtkEntryNew()
	entry3$SetText(inp[3])
	entry4<-gtkEntryNew()
	entry4$SetText(inp[4])
	entry5<-gtkEntryNew()
	entry5$SetText(inp[5])
	entry6<-gtkEntryNew()
	entry6$SetText(inp[6])
	diag_entry$packStart(entry1)
	diag_entry$packStart(entry2)
	diag_entry$packStart(entry3)
	diag_entry$packStart(entry4)
	diag_entry$packStart(entry5)
	diag_entry$packStart(entry6)
	diag_radio<-gtkVBox()
	radiogp<-list()
	radiogp$t1<-gtkRadioButtonNewWithLabel(group=NULL,label=vlabel[7])
	radiogp$t2<-gtkRadioButtonNewWithLabelFromWidget(group=radiogp$t1,label=vlabel[8])
	sapply(radiogp,diag_radio$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entry1$getText(),
								entry2$getText(),
								entry3$getText(),
								entry4$getText(),
								entry5$getText(),
								entry6$getText(),
								gtkToggleButtonGetActive(radiogp$t1),
								gtkToggleButtonGetActive(radiogp$t2)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_label)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_entry)
	table$attach(diag_align,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_radio,left.attach=1,2,top.attach=6,7,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,3,top.attach=9,10,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe7r2<-function(vlabel,inp){
	table<-gtkTable(rows=11,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	labelgp$t4<-gtkLabel(vlabel[4])
	labelgp$t5<-gtkLabel(vlabel[5])
	labelgp$t6<-gtkLabel(vlabel[6])
	labelgp$t7<-gtkLabel(vlabel[7])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entry1<-gtkEntryNew()
	entry1$SetText(inp[1])
	entry2<-gtkEntryNew()
	entry2$SetText(inp[2])
	entry3<-gtkEntryNew()
	entry3$SetText(inp[3])
	entry4<-gtkEntryNew()
	entry4$SetText(inp[4])
	entry5<-gtkEntryNew()
	entry5$SetText(inp[5])
	entry6<-gtkEntryNew()
	entry6$SetText(inp[6])
	entry7<-gtkEntryNew()
	entry7$SetText(inp[7])
	diag_entry$packStart(entry1)
	diag_entry$packStart(entry2)
	diag_entry$packStart(entry3)
	diag_entry$packStart(entry4)
	diag_entry$packStart(entry5)
	diag_entry$packStart(entry6)
	diag_entry$packStart(entry7)
	diag_radio<-gtkVBox()
	radiogp<-list()
	radiogp$t1<-gtkRadioButtonNewWithLabel(group=NULL,label=vlabel[8])
	radiogp$t2<-gtkRadioButtonNewWithLabelFromWidget(group=radiogp$t1,label=vlabel[9])
	sapply(radiogp,diag_radio$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entry1$getText(),
								entry2$getText(),
								entry3$getText(),
								entry4$getText(),
								entry5$getText(),
								entry6$getText(),
								entry7$getText(),
								gtkToggleButtonGetActive(radiogp$t1),
								gtkToggleButtonGetActive(radiogp$t2)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_label)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_entry)
	table$attach(diag_align,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_radio,left.attach=1,2,top.attach=6,7,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,3,top.attach=9,10,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe8r2<-function(vlabel,inp){
	table<-gtkTable(rows=14,columns=2,homogeneous=FALSE)
	tlabel1<-gtkLabel(vlabel[1])
	diag1_label<-gtkVBox()
	labelgp1<-list()
	labelgp1$t1<-gtkLabel(vlabel[2])
	labelgp1$t2<-gtkLabel(vlabel[3])
	labelgp1$t3<-gtkLabel(vlabel[4])
	sapply(labelgp1,diag1_label$packStart)
	diag1_entry<-gtkVBox()
	entrygp1<-list()
	entrygp1$t1<-gtkEntryNew()
	entrygp1$t2<-gtkEntryNew()
	entrygp1$t3<-gtkEntryNew()
	entrygp1$t1$setText(inp[1])
	entrygp1$t2$setText(inp[2])
	entrygp1$t3$setText(inp[3])
	sapply(entrygp1,diag1_entry$packStart)
	tlabel2<-gtkLabel(vlabel[5])
	diag2_label<-gtkVBox()
	labelgp2<-list()
	labelgp2$t1<-gtkLabel(vlabel[6])
	labelgp2$t2<-gtkLabel(vlabel[7])
	labelgp2$t3<-gtkLabel(vlabel[8])
	sapply(labelgp2,diag2_label$packStart)
	diag2_entry<-gtkVBox()
	entrygp2<-list()
	entrygp2$t1<-gtkEntryNew()
	entrygp2$t2<-gtkEntryNew()
	entrygp2$t3<-gtkEntryNew()
	entrygp2$t1$setText(inp[4])
	entrygp2$t2$setText(inp[5])
	entrygp2$t3$setText(inp[6])
	sapply(entrygp2,diag2_entry$packStart)
	tlabel3<-gtkLabel(vlabel[9])
	diag3_label<-gtkVBox()
	labelgp3<-list()
	labelgp3$t1<-gtkLabel(vlabel[10])
	labelgp3$t2<-gtkLabel(vlabel[11])
	sapply(labelgp3,diag3_label$packStart)
	diag3_entry<-gtkVBox()
	entrygp3<-list()
	entrygp3$t1<-gtkEntryNew()
	entrygp3$t2<-gtkEntryNew()
	entrygp3$t1$setText(inp[7])
	entrygp3$t2$setText(inp[8])
	sapply(entrygp3,diag3_entry$packStart)
	diag_radio<-gtkVBox()
	radiogp<-list()
	radiogp$t1<-gtkRadioButtonNewWithLabel(group=NULL,label=vlabel[12])
	radiogp$t2<-gtkRadioButtonNewWithLabelFromWidget(group=radiogp$t1,label=vlabel[13])
	sapply(radiogp,diag_radio$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entrygp1$t1$getText(),
								entrygp1$t2$getText(),
								entrygp1$t3$getText(),
								entrygp2$t1$getText(),
								entrygp2$t2$getText(),
								entrygp2$t3$getText(),
								entrygp3$t1$getText(),
								entrygp3$t2$getText(),
								gtkToggleButtonGetActive(radiogp$t1),
								gtkToggleButtonGetActive(radiogp$t2)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_radio)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag1_label)
	diag_align2<-gtkAlignment(xalign=0)
	diag_align2$add(diag1_entry)
	diag_align3<-gtkAlignment(xalign=0)
	diag_align3$add(diag2_label)
	diag_align4<-gtkAlignment(xalign=0)
	diag_align4$add(diag2_entry)
	diag_align5<-gtkAlignment(xalign=0)
	diag_align5$add(diag3_label)
	diag_align6<-gtkAlignment(xalign=0)
	diag_align6$add(diag3_entry)
	table$attach(tlabel1,left.attach=1,2,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align2,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(tlabel2,left.attach=1,2,top.attach=2,3,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align3,left.attach=0,1,top.attach=3,4,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align4,left.attach=1,2,top.attach=3,4,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(tlabel3,left.attach=1,2,top.attach=4,5,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align5,left.attach=0,1,top.attach=5,6,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align6,left.attach=1,2,top.attach=5,6,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align,left.attach=1,2,top.attach=6,7,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,2,top.attach=7,8,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxcr2<-function(vlabel,vcombo){
	table<-gtkTable(rows=4,columns=2,homogeneous=FALSE)
	label<-gtkLabel(vlabel[1])
	combo<-gtkComboBoxNewText()
	sapply(vcombo,combo$appendText)
	combo$setActive(0)
	diag_label<-gtkLabel(vlabel[2])
	diag_radio<-gtkVBox()
	radiogp<-list()
	radiogp$t1<-gtkRadioButtonNewWithLabel(group=NULL,label=vlabel[3])	
	radiogp$t2<-gtkRadioButtonNewWithLabelFromWidget(group=radiogp$t1,label=vlabel[4])
	sapply(radiogp,diag_radio$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(as.integer(combo$getActive())+1,
									gtkToggleButtonGetActive(radiogp$t1),
									gtkToggleButtonGetActive(radiogp$t2)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	table$attach(label,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))	
	table$attach(combo,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_label,left.attach=0,1,top.attach=2,3,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_radio,left.attach=1,2,top.attach=2,3,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,2,top.attach=3,4,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxcr3<-function(vlabel,vcombo){
	table<-gtkTable(rows=5,columns=2,homogeneous=FALSE)
	label<-gtkLabel(vlabel[1])
	combo<-gtkComboBoxNewText()
	sapply(vcombo,combo$appendText)
	diag_label<-gtkLabel(vlabel[2])
	diag_radio<-gtkVBox()
	radiogp<-list()
	radiogp$t1<-gtkRadioButtonNewWithLabel(group=NULL,label=vlabel[3])
	radiogp$t2<-gtkRadioButtonNewWithLabelFromWidget(group=radiogp$t1,label=vlabel[4])
	radiogp$t3<-gtkRadioButtonNewWithLabelFromWidget(group=radiogp$t1,label=vlabel[5])
	sapply(radiogp,diag_radio$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(as.integer(combo$getActive())+1,
								gtkToggleButtonGetActive(radiogp$t1),
								gtkToggleButtonGetActive(radiogp$t2),
								gtkToggleButtonGetActive(radiogp$t3)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	table$attach(label,left.attach=0,1,top.attach=0,1,xoptions=c('expand','fill'),yoptions='')
	table$attach(combo,left.attach=1,2,top.attach=0,1,xoptions='fill',yoptions='')
	table$attach(diag_label,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_radio,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,5,top.attach=2,5,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxcr4<-function(vlabel,vcombo){
	table<-gtkTable(rows=4,columns=2,homogeneous=FALSE)
	label<-gtkLabel(vlabel[1])
	combo<-gtkComboBoxNewText()
	sapply(vcombo,combo$appendText)
	diag_label<-gtkLabel(vlabel[2])
	diag_radio<-gtkVBox()
	radiogp<-list()
	radiogp$t1<-gtkRadioButtonNewWithLabel(group=NULL,label=vlabel[3])
	radiogp$t2<-gtkRadioButtonNewWithLabelFromWidget(group=radiogp$t1,label=vlabel[4])
	radiogp$t3<-gtkRadioButtonNewWithLabelFromWidget(group=radiogp$t1,label=vlabel[5])
	radiogp$t4<-gtkRadioButtonNewWithLabelFromWidget(group=radiogp$t1,label=vlabel[6])
	sapply(radiogp,diag_radio$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(as.integer(combo$getActive())+1,
								gtkToggleButtonGetActive(radiogp$t1),
								gtkToggleButtonGetActive(radiogp$t2),
								gtkToggleButtonGetActive(radiogp$t3),
								gtkToggleButtonGetActive(radiogp$t4)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	label['xalign']<-1
	diag_label['xalign']<-1
	diag_label['yalign']<-0
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_radio)
	table$attach(label,left.attach=0,1,top.attach=0,1,xoptions=c('expand','fill'),yoptions='')
	table$attach(combo,left.attach=1,2,top.attach=0,1,xoptions='fill',yoptions='')
	table$attach(diag_label,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions='')
	table$attach(submit_hbox,left.attach=0,4,top.attach=2,4,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxk6<-function(vlabel,inp){
	table<-gtkTable(rows=8,columns=2,homogeneous=FALSE)
	diag_check<-gtkVBox()
	checkgp<-list()
	checkgp$t1<-gtkCheckButtonNewWithLabel(label=vlabel[1])
	checkgp$t1$SetActive(as.logical(inp[1]))
	checkgp$t2<-gtkCheckButtonNewWithLabel(label=vlabel[2])
	checkgp$t2$SetActive(as.logical(inp[2]))
	checkgp$t3<-gtkCheckButtonNewWithLabel(label=vlabel[3])
	checkgp$t3$SetActive(as.logical(inp[3]))
	checkgp$t4<-gtkCheckButtonNewWithLabel(label=vlabel[4])
	checkgp$t4$SetActive(as.logical(inp[4]))
	checkgp$t5<-gtkCheckButtonNewWithLabel(label=vlabel[5])
	checkgp$t5$SetActive(as.logical(inp[5]))
	checkgp$t6<-gtkCheckButtonNewWithLabel(label=vlabel[6])
	checkgp$t6$SetActive(as.logical(inp[6]))
	sapply(checkgp,diag_check$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(gtkToggleButtonGetActive(checkgp$t1),
									gtkToggleButtonGetActive(checkgp$t2),
									gtkToggleButtonGetActive(checkgp$t3),
									gtkToggleButtonGetActive(checkgp$t4),
									gtkToggleButtonGetActive(checkgp$t5),
									gtkToggleButtonGetActive(checkgp$t6)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	table$attach(diag_check,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,1,top.attach=2,3,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxk7k7<-function(vlabel,vtitle,inp){
	table<-gtkTable(rows=11,columns=4,homogeneous=FALSE)
	label_hbox<-gtkHBox()
	mainlab1<-gtkLabel(vtitle[1])
	mainlab2<-gtkLabel(vtitle[2])
	label_hbox$packStart(mainlab1,expand=TRUE)	
	label_hbox$packEnd(mainlab2,expand=TRUE)
	diag_label<-gtkVBox()
	diag_check1<-gtkVBox()
	check1gp<-list()
	check1gp$t1<-gtkCheckButtonNewWithLabel(label=vlabel[1])
	check1gp$t1$SetActive(as.logical(inp[1]))
	check1gp$t2<-gtkCheckButtonNewWithLabel(label=vlabel[2])
	check1gp$t2$SetActive(as.logical(inp[2]))
	check1gp$t3<-gtkCheckButtonNewWithLabel(label=vlabel[3])
	check1gp$t3$SetActive(as.logical(inp[3]))
	check1gp$t4<-gtkCheckButtonNewWithLabel(label=vlabel[4])
	check1gp$t4$SetActive(as.logical(inp[4]))
	check1gp$t5<-gtkCheckButtonNewWithLabel(label=vlabel[5])
	check1gp$t5$SetActive(as.logical(inp[5]))
	check1gp$t6<-gtkCheckButtonNewWithLabel(label=vlabel[6])
	check1gp$t6$SetActive(as.logical(inp[6]))
	check1gp$t7<-gtkCheckButtonNewWithLabel(label=vlabel[7])
	check1gp$t7$SetActive(as.logical(inp[7]))
	sapply(check1gp,diag_check1$packStart)
	diag_check2<-gtkVBox()
	check2gp<-list()
	check2gp$t1<-gtkCheckButtonNewWithLabel(label=vlabel[8])
	check2gp$t1$SetActive(as.logical(inp[8]))
	check2gp$t2<-gtkCheckButtonNewWithLabel(label=vlabel[9])
	check2gp$t2$SetActive(as.logical(inp[9]))
	check2gp$t3<-gtkCheckButtonNewWithLabel(label=vlabel[10])
	check2gp$t3$SetActive(as.logical(inp[10]))
	check2gp$t4<-gtkCheckButtonNewWithLabel(label=vlabel[11])
	check2gp$t4$SetActive(as.logical(inp[11]))
	check2gp$t5<-gtkCheckButtonNewWithLabel(label=vlabel[12])
	check2gp$t5$SetActive(as.logical(inp[12]))
	check2gp$t6<-gtkCheckButtonNewWithLabel(label=vlabel[13])
	check2gp$t6$SetActive(as.logical(inp[13]))
	check2gp$t7<-gtkCheckButtonNewWithLabel(label=vlabel[14])
	check2gp$t7$SetActive(as.logical(inp[14]))
	sapply(check2gp,diag_check2$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(c(gtkToggleButtonGetActive(check1gp$t1),
								gtkToggleButtonGetActive(check1gp$t2),
								gtkToggleButtonGetActive(check1gp$t2),
								gtkToggleButtonGetActive(check1gp$t4),
								gtkToggleButtonGetActive(check1gp$t5),
								gtkToggleButtonGetActive(check1gp$t6),
								gtkToggleButtonGetActive(check1gp$t7)),
								c(gtkToggleButtonGetActive(check2gp$t1),
								gtkToggleButtonGetActive(check2gp$t2),
								gtkToggleButtonGetActive(check2gp$t2),
								gtkToggleButtonGetActive(check2gp$t4),
								gtkToggleButtonGetActive(check2gp$t5),
								gtkToggleButtonGetActive(check2gp$t6),
								gtkToggleButtonGetActive(check2gp$t7))))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_check1)
	diag_align2<-gtkAlignment(xalign=0)
	diag_align2$add(diag_check2)
	table$attach(label_hbox,left.attach=0,4,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align2,left.attach=3,4,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,4,top.attach=10,11,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxcke<-function(vlabel,vcombo,inp){
	table<-gtkTable(rows=5,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	sapply(labelgp,diag_label$packStart)
	diag_inp<-gtkVBox()
	combo<-gtkComboBoxNewText()
	sapply(vcombo,combo$appendText)
	combo$SetActive(as.integer(inp[1]))
	check<-gtkCheckButtonNew()
	check$SetActive(as.logical(inp[2]))
	entry<-gtkEntryNew()
	entry$setText(inp[3])
	diag_inp$packStart(combo)
	diag_inp$packStart(check)
	diag_inp$packStart(entry)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(combo$getActive()+1,
								gtkToggleButtonGetActive(check),
								entry$getText()))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_label)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_inp)
	table$attach(diag_align,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,3,top.attach=5,6,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxck<-function(vlabel,vcombo,inp){
	table<-gtkTable(rows=3,columns=2,homogeneous=FALSE)
	label<-gtkLabel(vlabel[1])
	combo<-gtkComboBoxNewText()
	combo$SetActive(as.integer(inp[1]))
	sapply(vcombo,combo$appendText)
	check<-gtkCheckButtonNewWithLabel(label=vlabel[2])
	check$SetActive(inp[2])
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(as.integer(combo$getActive())+1,
								gtkToggleButtonGetActive(check)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	label['xalign']<-1
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(check)
	table$attach(label,left.attach=0,1,top.attach=0,1,xoptions=c('expand','fill'),yoptions='')
	table$attach(combo,left.attach=1,2,top.attach=0,1,xoptions='fill',yoptions='')
	table$attach(diag_align,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions='')
	table$attach(submit_hbox,left.attach=0,3,top.attach=2,3,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxc2k<-function(vlabel,vcombo1,vcombo2,inp){
	table<-gtkTable(rows=4,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	sapply(labelgp,diag_label$packStart)
	diag_combo<-gtkVBox()
	combogp<-list()
	combogp$t1<-gtkComboBoxNewText()
	sapply(vcombo1,combogp$t1$appendText)
	combogp$t1$setActive(inp[1])
	combogp$t2<-gtkComboBoxNewText()
	sapply(vcombo2,combogp$t2$appendText)
	combogp$t2$setActive(inp[2])
	sapply(combogp,diag_combo$packStart)
	check<-gtkCheckButtonNewWithLabel(label=vlabel[3])
	check$SetActive(inp[3])
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(as.integer(combogp$t1$getActive())+1,
								as.integer(combogp$t2$getActive())+1,
								gtkToggleButtonGetActive(check)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_label)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_combo)
	diag_align2<-gtkAlignment(xalign=0)
	diag_align2$add(check)
	table$attach(diag_align,left.attach=0,1,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=1,2,top.attach=0,1,xoptions='fill',yoptions='')
	table$attach(diag_align2,left.attach=1,2,top.attach=1,2,xoptions=c('expand','fill'),yoptions='')
	table$attach(submit_hbox,left.attach=0,3,top.attach=2,3,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxecece<-function(vlabel,vcombo1,vcombo2,inp){
	table<-gtkTable(rows=6,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	labelgp$t4<-gtkLabel(vlabel[4])
	labelgp$t5<-gtkLabel(vlabel[5])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entry1<-gtkEntryNew()
	entry1$setText(inp[1])
	combo1<-gtkComboBoxNewText()
	sapply(vcombo1,combo1$appendText)
	combo1$setActive(inp[2])
	entry2<-gtkEntryNew()
	entry2$setText(inp[3])
	combo2<-gtkComboBoxNewText()
	sapply(vcombo2,combo2$appendText)
	combo2$setActive(inp[4])
	entry3<-gtkEntryNew()
	entry3$setText(inp[5])
	diag_entry$packStart(entry1)
	diag_entry$packStart(combo1)
	diag_entry$packStart(entry2)
	diag_entry$packStart(combo2)
	diag_entry$packStart(entry3)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entry1$getText(),
								entry2$getText(),
								entry3$getText(),
								combo1$getActive()+1,
								combo2$getActive()+1))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_label)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_entry)
	table$attach(diag_align,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=1,2,top.attach=1,2,xoptions='',yoptions='')
	table$attach(submit_hbox,left.attach=0,3,top.attach=5,6,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe3ce<-function(vlabel,vcombo,inp){
	table<-gtkTable(rows=6,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	labelgp$t4<-gtkLabel(vlabel[4])
	labelgp$t5<-gtkLabel(vlabel[5])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entry1<-gtkEntryNew()
	entry1$SetText(inp[1])
	combo1<-gtkComboBoxNewText()
	sapply(vcombo,combo1$appendText)
	combo1$SetActive(as.integer(inp[5]))
	entry2<-gtkEntryNew()
	entry2$SetText(inp[2])
	entry3<-gtkEntryNew()
	entry3$SetText(inp[3])
	entry4<-gtkEntryNew()
	entry4$SetText(inp[4])
	diag_entry$packStart(entry1)
	diag_entry$packStart(entry2)
	diag_entry$packStart(entry3)
	diag_entry$packStart(combo1)
	diag_entry$packStart(entry4)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entry1$getText(),
								entry2$getText(),
								entry3$getText(),
								entry4$getText(),
								combo1$getActive()+1))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_label)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_entry)
	table$attach(diag_align,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=1,2,top.attach=1,2,xoptions='',yoptions='')
	table$attach(submit_hbox,left.attach=0,3,top.attach=5,6,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxe4cek2<-function(vlabel,vcombo,inp){
	table<-gtkTable(rows=8,columns=2,homogeneous=FALSE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[1])
	labelgp$t2<-gtkLabel(vlabel[2])
	labelgp$t3<-gtkLabel(vlabel[3])
	labelgp$t4<-gtkLabel(vlabel[4])
	labelgp$t5<-gtkLabel(vlabel[5])
	labelgp$t6<-gtkLabel(vlabel[6])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entry1<-gtkEntryNew()
	entry1$SetText(inp[1])
	combo1<-gtkComboBoxNewText()
	sapply(vcombo,combo1$appendText)
	combo1$SetActive(as.integer(inp[8]))
	entry2<-gtkEntryNew()
	entry2$SetText(inp[2])
	entry3<-gtkEntryNew()
	entry3$SetText(inp[3])
	entry4<-gtkEntryNew()
	entry4$SetText(inp[4])
	entry5<-gtkEntryNew()
	entry5$SetText(inp[5])
	diag_entry$packStart(entry1)
	diag_entry$packStart(entry2)
	diag_entry$packStart(entry3)
	diag_entry$packStart(entry4)
	diag_entry$packStart(combo1)
	diag_entry$packStart(entry5)
	diag_check<-gtkHBox()
	checkgp<-list()
	checkgp$t1<-gtkCheckButtonNewWithLabel(label=vlabel[7])
	checkgp$t1$SetActive(as.logical(inp[6]))
	checkgp$t2<-gtkCheckButtonNewWithLabel(label=vlabel[8])
	checkgp$t2$SetActive(as.logical(inp[7]))
	sapply(checkgp,diag_check$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(entry1$getText(),
								entry2$getText(),
								entry3$getText(),
								entry4$getText(),
								entry5$getText(),
								combo1$getActive()+1,
								gtkToggleButtonGetActive(checkgp$t1),
								gtkToggleButtonGetActive(checkgp$t2)))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_align<-gtkAlignment(xalign=0)
	diag_align$add(diag_label)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_entry)
	table$attach(diag_align,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=1,2,top.attach=1,2,xoptions='',yoptions='')
	table$attach(diag_check,left.attach=1,2,top.attach=6,7,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,3,top.attach=7,8,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}

inpboxlist<-function(vnames,ltitle){
	DF<-as.data.frame(vnames)
	vspec<-rep(FALSE,nrow(DF))
	model<-rGtkDataFrame(cbind(DF,.toggle=vspec))
	view<-gtkTreeView()
	cell_renderer<-gtkCellRendererToggle()
	view$insertColumnWithAttributes(0,"",cell_renderer,active=ncol(DF))
	gSignalConnect(cell_renderer,"toggled",function(cell_renderer,path,user.data){
			view<-user.data
			row<-as.numeric(path)+1
			model<-view$getModel()
			n<-dim(model)[2]
			model[row,n]<-!model[row,n]
			}
		,data=view
	)
	mapply(view$insertColumnWithAttributes,-1,title=c(ltitle),list(gtkCellRendererText()),text=seq_along(DF)-1L)
	view$setModel(model)
	button_ok<-gtkButton("OK")
	gSignalConnect(button_ok,"clicked",function(button_ok,data){
			view<-data	
			model<-view$getModel()
			ans<-model[model[,ncol(model)],-ncol(model),drop=FALSE]
			button_ok$setData('ans',ans)
			gtkMainQuit()
			}
		,data=view
	)
	button_cn<-gtkButton("Cancel")
	gSignalConnect(button_cn,"clicked",function(button_cn,data){
	button_ok$setData('ans',FALSE)
	gtkMainQuit()})
	window<-gtkWindow(show=FALSE)
	window$setTitle("Selection form a list")
	window$setSizeRequest(300,300)
	hbox<-gtkHBox()
	hbox$packStart(button_cn,expand=TRUE,fill=TRUE)
	hbox$packStart(button_ok,expand=TRUE,fill=TRUE)
	vbox<-gtkVBox();window$add(vbox)
	scrolled_window<-gtkScrolledWindow()
	vbox$packStart(scrolled_window,expand=TRUE,fill=TRUE)
	scrolled_window$add(view)
	scrolled_window$setPolicy("automatic","automatic")
	vbox$packStart(hbox,expand=FALSE,fill=FALSE)
	window$show()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	ans<-as.numeric(row.names(ans))
	return(ans)
}

inpboxk6k6e6<-function(vlabel,vtitle,inp){
	table<-gtkTable(rows=11,columns=8,homogeneous=FALSE)
	label_hbox<-gtkHBox()
	mainlab1<-gtkLabel(vtitle[1])
	mainlab2<-gtkLabel(vtitle[2])
	label_hbox$packStart(mainlab1,expand=TRUE)
	label_hbox$packEnd(mainlab2,expand=TRUE)
	diag_label<-gtkVBox()
	labelgp<-list()
	labelgp$t1<-gtkLabel(vlabel[13])
	labelgp$t2<-gtkLabel(vlabel[14])
	labelgp$t3<-gtkLabel(vlabel[15])
	labelgp$t4<-gtkLabel(vlabel[16])
	labelgp$t5<-gtkLabel(vlabel[17])
	labelgp$t6<-gtkLabel(vlabel[18])
	sapply(labelgp,diag_label$packStart)
	diag_entry<-gtkVBox()
	entrygp<-list()
	entrygp$t1<-gtkEntryNew()
	gtkEntrySetMaxLength(entrygp$t1,3)
	entrygp$t1$SetText(inp[1])
	entrygp$t2<-gtkEntryNew()
	gtkEntrySetMaxLength(entrygp$t2,3)
	entrygp$t2$SetText(inp[2])
	entrygp$t3<-gtkEntryNew()
	gtkEntrySetMaxLength(entrygp$t3,3)
	entrygp$t3$SetText(inp[3])
	entrygp$t4<-gtkEntryNew()
	gtkEntrySetMaxLength(entrygp$t4,3)
	entrygp$t4$SetText(inp[4])
	entrygp$t5<-gtkEntryNew()
	gtkEntrySetMaxLength(entrygp$t5,3)
	entrygp$t5$SetText(inp[5])
	entrygp$t6<-gtkEntryNew()
	gtkEntrySetMaxLength(entrygp$t6,3)
	entrygp$t6$SetText(inp[6])
	sapply(entrygp,diag_entry$packStart)
	diag_check1<-gtkVBox()
	check1gp<-list()
	check1gp$t1<-gtkCheckButtonNewWithLabel(label=vlabel[1])
	check1gp$t1$SetActive(as.logical(inp[7]))
	check1gp$t2<-gtkCheckButtonNewWithLabel(label=vlabel[2])
	check1gp$t2$SetActive(as.logical(inp[8]))
	check1gp$t3<-gtkCheckButtonNewWithLabel(label=vlabel[3])
	check1gp$t3$SetActive(as.logical(inp[9]))
	check1gp$t4<-gtkCheckButtonNewWithLabel(label=vlabel[4])
	check1gp$t4$SetActive(as.logical(inp[10]))
	check1gp$t5<-gtkCheckButtonNewWithLabel(label=vlabel[5])
	check1gp$t5$SetActive(as.logical(inp[11]))
	check1gp$t6<-gtkCheckButtonNewWithLabel(label=vlabel[6])
	check1gp$t6$SetActive(as.logical(inp[12]))
	sapply(check1gp,diag_check1$packStart)
	diag_check2<-gtkVBox()
	check2gp<-list()
	check2gp$t1<-gtkCheckButtonNewWithLabel(label=vlabel[7])
	check2gp$t1$SetActive(as.logical(inp[13]))
	check2gp$t2<-gtkCheckButtonNewWithLabel(label=vlabel[8])
	check2gp$t2$SetActive(as.logical(inp[14]))
	check2gp$t3<-gtkCheckButtonNewWithLabel(label=vlabel[9])
	check2gp$t3$SetActive(as.logical(inp[15]))
	check2gp$t4<-gtkCheckButtonNewWithLabel(label=vlabel[10])
	check2gp$t4$SetActive(as.logical(inp[16]))
	check2gp$t5<-gtkCheckButtonNewWithLabel(label=vlabel[11])
	check2gp$t5$SetActive(as.logical(inp[17]))
	check2gp$t6<-gtkCheckButtonNewWithLabel(label=vlabel[12])
	check2gp$t6$SetActive(as.logical(inp[18]))
	sapply(check2gp,diag_check2$packStart)
	submit_hbox<-gtkHBox()
	button_ok<-gtkButton("OK")
	button_canc<-gtkButton("Cancel")
	submit_hbox$packStart(button_ok,expand=TRUE)
	submit_hbox$packEnd(button_canc,expand=TRUE)
	gSignalConnect(button_ok,"clicked",f=function(button_ok){
		button_ok$setData('ans',list(c(gtkToggleButtonGetActive(check1gp$t1),
								gtkToggleButtonGetActive(check1gp$t2),
								gtkToggleButtonGetActive(check1gp$t3),
								gtkToggleButtonGetActive(check1gp$t4),
								gtkToggleButtonGetActive(check1gp$t5),
								gtkToggleButtonGetActive(check1gp$t6)),
								c(gtkToggleButtonGetActive(check2gp$t1),
								gtkToggleButtonGetActive(check2gp$t2),
								gtkToggleButtonGetActive(check2gp$t3),
								gtkToggleButtonGetActive(check2gp$t4),
								gtkToggleButtonGetActive(check2gp$t5),
								gtkToggleButtonGetActive(check2gp$t6)),
								c(entrygp$t1$getText(),
								entrygp$t2$getText(),
								entrygp$t3$getText(),
								entrygp$t4$getText(),
								entrygp$t5$getText(),
								entrygp$t6$getText())))
		gtkMainQuit()
		}
	)
	gSignalConnect(button_canc,"clicked",f=function(button_canc){
		button_ok$setData('ans',NULL)
		gtkMainQuit()
		}
	)
	diag_alignl<-gtkAlignment(xalign=0)
	diag_alignl$add(diag_label)
	diag_aligne<-gtkAlignment(xalign=0)
	diag_aligne$add(diag_entry)
	diag_align1<-gtkAlignment(xalign=0)
	diag_align1$add(diag_check1)
	diag_align2<-gtkAlignment(xalign=0)
	diag_align2$add(diag_check2)
	table$attach(label_hbox,left.attach=0,4,top.attach=0,1,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align1,left.attach=0,1,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_align2,left.attach=3,4,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_alignl,left.attach=5,7,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(diag_aligne,left.attach=7,8,top.attach=1,2,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,8,top.attach=10,11,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$setColSpacing(0,5)
	window<-gtkWindow(show=FALSE)
	window['border-width']<-14
	window$setTitle('Input Choice')
	window$SetDeletable(FALSE)
	window$add(table)
	window$showAll()
	gtkMain()
	ans<-button_ok$GetData('ans')
	window$Destroy()
	return(ans)
}
# begin of workspace_management function
workspace_management<-function(previous.name=''){
	# definition of internal functions
	tellme<-function(mname){
		M<-eval(parse(text=mname),envir=.GlobalEnv)
		if(!is.null(M)|is.data.frame(M)|is.matrix(M)|is.vector(M)){
			if(is.vector(M))M<-matrix(M,length(M),1)
			nna<-sum(is.na(M))
			ntype<-attributes(M)$class
			if(!is.null(ntype)){
				nro<-nrow(M)
				ncl<-ncol(M)
				nacl<-attributes(M)$names
				naro<-attributes(M)$row.names
			}else{
				if(is.matrix(M)){
					ntype<-'matrix'
					nro<-dim(M)[1]
					ncl<-dim(M)[2]
					nacl<-colnames(M)
					naro<-rownames(M)
				}
			}
			sink("tellme.txt")
			print(paste('**************************************************************************'),quote=FALSE)
			print(paste('Name                  : ',mname),quote=FALSE)
			print(paste('Type                  : ',ntype),quote=FALSE)
			print(paste('Row                   : ',nro),quote=FALSE)
			print(paste('Column                : ',ncl),quote=FALSE)
			print(paste('NA                    : ',nna),quote=FALSE)
			nap<-nna/(nro*ncl)*100
			print(paste('%NA                   : ',format(nap,digits=1)),quote=FALSE)
			print(paste('Column Names          : '),quote=FALSE)
			print(nacl,quote=FALSE)
			print(paste('Row Names             : '),quote=FALSE)
			print(naro,quote=FALSE)
			print(paste('**************************************************************************'),quote=FALSE)
			sink()
			file.edit('tellme.txt')
		}else{
			ans<-messagebox('Only whole Variable. Not a part !')
		}
		return()
	}
	copyme<-function(mname,previous.name){
		M<-eval(parse(text=mname),envir=.GlobalEnv)
		new.name<-inpboxe1('New Name',previous.name)
		if(!is.null(new.name)){
			new.name<-unlist(new.name)
			oyn<-TRUE
			if(exists(new.name,envir=.GlobalEnv)){
				oyn<-messageyesno('Variable Exists.Overwrite ?')
				oyn<-as.logical(unlist(oyn))
			}
			if(oyn){
				assign(new.name,M,envir=env_menucollection)
				print(paste(mname,'copied in',new.name))  
				assign('previous.name',new.name,envir=env_menucollection)
			}
		}
		return()
	}
	transposeme<-function(mname,previous.name){
		M<-eval(parse(text=mname),envir=.GlobalEnv)
		new.name<-inpboxe1('New Name',previous.name)
		if(!is.null(new.name)){
			new.name<-unlist(new.name)
			oyn<-TRUE
			if(exists(new.name,envir=.GlobalEnv)){
				oyn<-messageyesno('Variable Exists.Overwrite ?')
				oyn<-as.logical(unlist(oyn))
			}
			if(oyn){
				if((typeof(M)=='list')|(typeof(M)=='double')){
					Mt<-t(M)
					assign(new.name,Mt,envir=env_menucollection)
					print(paste(mname,'transposed')) 
					assign('previous.name',new.name,envir=env_menucollection)
					if(typeof(M)=='list'){
						assign('nar',row.names(M),envir=env_menucollection)
						assign('nac',names(M),envir=env_menucollection)
						print('You transposed a table: row and column names are saved in : nar and nac variables for future use')
					}
				}else{
					ans<-messagebox('Only Matrix for this Function!')
				}
			}
		}
		return()
	}
	modifyme<-function(mname){
		M<-eval(parse(text=mname),envir=.GlobalEnv)
		M<-as.data.frame(M)
		M<-dfedit(M,size=c(600,300),editable=TRUE)
		assign(mname,as.data.frame(M),envir=env_menucollection)
		print(paste(mname,'modified') ) 
		assign('previous.name',mname,envir=env_menucollection)
		return()
	}
	newme<-function(){
		nl<-inpboxe3(c('*Matrix Name','*Number of Rows','*Number of Columns'),rep('',3))
		if(!is.null(nl)){
			new.name<-nl[[1]]
			nr<-as.integer(nl[[2]])
			nc<-as.integer(nl[[3]])
			oyn<-TRUE
			if(exists(new.name,envir=.GlobalEnv)){
				oyn<-messageyesno('Variable Exists.Overwrite ?')
				oyn<-as.logical(unlist(oyn))
			}
			if(oyn){
				M<-matrix(rep(0,nr*nc),nr,nc)
				M<-dfedit(as.data.frame(M))
				assign(new.name,as.data.frame(M),envir=env_menucollection)
				print(paste(new.name,'created') ) 
				assign('previous.name',new.name,envir=env_menucollection)
			}
		}
		return()
	}
	mergeme<-function(mname,previous.name){
		M<-eval(parse(text=mname),envir=.GlobalEnv)
		rM<-dim(M)[1]
		cM<-dim(M)[2]
		new.name<-inpboxe1('Merge With:','')
		if(!is.null(new.name)){
			N<-eval(parse(text=new.name),envir=.GlobalEnv)
			rN<-dim(N)[1]
			cN<-dim(N)[2]
			if((rM==rN)&(cM!=cN))M<-cbind(M,N)
			if((rM!=rN)&(cM==cN))M<-rbind(M,N)
			if((rM==rN)&(cM==cN)){
				oyn<-messageyesno('Merge vertically ?')
				oyn<-as.logical(unlist(oyn))
				if(oyn)M<-rbind(M,N)
				if(!oyn)M<-cbind(M,N)
			}
			assign(mname,M,envir=env_menucollection)
			print(paste(new.name,'merged in',mname)) 
			if((rM!=rN)&(cM!=cN)){
				ans<-messagebox('Incompatible Matrices!')
			}
		}
		return()
	}
	# function body
	pos<-1
	env_menucollection<-as.environment(pos)
	items<-ls(envir=.GlobalEnv)
	items<-items[items!='ans']
	items<-items[items!='perlpath']
	items<-items[items!='previous.name']
	typ<-NULL;siz<-NULL
	if(length(items)>0){
		for(i in 1:length(items))typ<-c(typ,typeof(get(items[i])))
		for(i in 1:length(items))siz<-c(siz,object.size(get(items[i]))) 
	}else{
		items<-''
		typ<-''
		siz<-''
		i<-0
	}
	mitems<-data.frame(Name=items,Type=typ,Size=siz)
	model<-rGtkDataFrame(mitems)
	view<-gtkTreeView(model)
	selection<-view$getSelection()
	selection$setMode("single")
	mapply(view$insertColumnWithAttributes,position=-1,title=colnames(model),
	cell=list(gtkCellRendererText()),text=seq_len(ncol(mitems))-1)
	scrolled_window<-gtkScrolledWindow()
	scrolled_window$add(view)
	table<-gtkTable(rows=11,columns=2,homogeneous=FALSE)
	submit_hbox<-gtkHBox()
	button_tell<-gtkButton("Tell Me")
	button_copy<-gtkButton("Copy")
	button_merge<-gtkButton("Merge")
	button_tran<-gtkButton("Transp.")
	button_mod<-gtkButton("Modify")
	button_new<-gtkButton("New")
	button_close<-gtkButton("Close")
	button_del<-gtkButton("Delete")
	button_del$setData('mitems',mitems)
	button_copy$setData("previous.name",previous.name)
	button_tran$setData("previous.name",previous.name)
	button_merge$setData("previous.name",previous.name)
	gSignalConnect(button_del,signal="clicked",f=function(button_del){
		selected<-selection$getSelected()
		if(selected[[1]]){
			name.selected<-with(selected,model$getValue(iter,0)$value)
			rm(list=name.selected,envir=.GlobalEnv)
			print(paste(as.character(name.selected),'removed from memory'))
		}
		iter<-selected$iter
		path<-model$getPath(iter)
		i<-path$getIndices()[[1]]
		mitems<-button_del$GetData('mitems')
		mitems<-mitems[-(i+1),]
		button_del$setData('mitems',mitems)	
		model$setFrame(mitems)
		return(TRUE)
		}
	)
	gSignalConnect(button_close,signal="clicked",f=function(button_close){
		gtkMainQuit()
		window$Destroy()
		return(TRUE)
		}
	)
	gSignalConnect(button_tell,signal="clicked",f=function(button_tell){
		selected<-selection$getSelected()
		if(selected[[1]]){
			name.selected<-with(selected,model$getValue(iter,0)$value)
			tellme(name.selected)
			gtkMainQuit()
			window$Destroy()
		}
		return(TRUE)
		}
	)
	gSignalConnect(button_copy,signal="clicked",f=function(button_copy){
		selected<-selection$getSelected()
		if(selected[[1]]){
			name.selected<-with(selected,model$getValue(iter,0)$value)
			copyme(name.selected,button_copy$getData("previous.name"))
			gtkMainQuit()
			window$Destroy()
		}
		return(TRUE)
		}
	)
	gSignalConnect(button_mod,signal="clicked",f=function(button_mod){
		selected<-selection$getSelected()
		if(selected[[1]]){
			name.selected<-with(selected,model$getValue(iter,0)$value)
			modifyme(name.selected)
			gtkMainQuit()
			window$Destroy()
		}
		return(TRUE)
		}
	)
	gSignalConnect(button_new,signal="clicked",f=function(button_new){
		newme()
		gtkMainQuit()
		window$Destroy()
		return(TRUE)
		}
	)
	gSignalConnect(button_merge,signal="clicked",f=function(button_merge){
		selected<-selection$getSelected()
		name.selected<-with(selected,model$getValue(iter,0)$value)
		mergeme(name.selected,button_merge$getData("previous.name"))
		gtkMainQuit()
		window$Destroy()
		return(TRUE)
		}
	)
	gSignalConnect(button_tran,signal="clicked",f=function(button_tran){
		selected<-selection$getSelected()
		name.selected<-with(selected,model$getValue(iter,0)$value)
		transposeme(name.selected,button_tran$getData("previous.name"))
		gtkMainQuit()
		window$Destroy()
		return(TRUE)
		}
	)
	submit_hbox$packStart(button_copy,expand=TRUE)
	submit_hbox$packStart(button_del,expand=TRUE)
	submit_hbox$packStart(button_merge,expand=TRUE)
	submit_hbox$packStart(button_mod,expand=TRUE)
	submit_hbox$packStart(button_new,expand=TRUE)
	submit_hbox$packStart(button_tell,expand=TRUE)
	submit_hbox$packEnd(button_tran,expand=TRUE)
	table$attach(scrolled_window,left.attach=0,2,top.attach=0,9,xoptions=c('expand','fill'),yoptions=c('expand','fill'))
	table$attach(submit_hbox,left.attach=0,2,top.attach=9,10,xoptions=c('expand','fill'),yoptions='')
	table$attach(button_close,left.attach=0,2,top.attach=10,11,xoptions=c('expand','fill'),yoptions='')
	table$setColSpacing(0,10)
	window<-gtkWindow(show=FALSE)
	window$setDefaultSize(300,500)
	window$SetDeletable(FALSE)
	window['border-width']<-14
	window$setTitle('WorkSpace')
	window$add(table)
	window$showAll()
	gtkMain()
}
# end of workspace_management function
