% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateFWHM.R
\name{calculateFWHM}
\alias{calculateFWHM}
\title{Calculate FWHM2Base (of a Chromatographic Peak)}
\usage{
calculateFWHM(peakData, pts)
}
\arguments{
\item{peakData}{A vector containing characteristic information about a chromatographic peak - including the retention time range}

\item{pts}{A 2D matrix containing the retention time and intensity values of a chromatographic peak}
}
\value{
The FWHM2Base value (double)
}
\description{
Calculates the FWHM2Base of the integrated region of a chromatographic peak. The FWHM2Base is found by determining the peak width
at half of the maximum intensity and normalizing this value by the width of the base of the peak.
}
\details{
This function repurposed from TargetedMSQC. Toghi Eshghi, S., Auger, P., & Mathews, W. R. (2018). Quality assessment and
interference detection in targeted mass spectrometry data using machine learning. Clinical Proteomics, 15.
https://doi.org/10.1186/s12014-018-9209-x
}
\examples{
# Calculate FWHM2Base for a peak
data(ex_pts)
data(ex_peakData)
fwhm <- calculateFWHM(peakData=ex_peakData, pts=ex_pts)

}
