% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateJaggedness.R
\name{calculateJaggedness}
\alias{calculateJaggedness}
\title{Calculate Jaggedness (of a Chromatographic Peak)}
\usage{
calculateJaggedness(peakData, pts, flatness.factor = 0.05)
}
\arguments{
\item{peakData}{A vector containing characteristic information about a chromatographic peak - including the retention time range}

\item{pts}{A 2D matrix containing the retention time and intensity values of a chromatographic peak}

\item{flatness.factor}{A numeric value between 0 and 1 that allows the user to adjust the sensitivity of the function to noise. This
function calculates the difference between each adjacent pair of points; any value found to be less than flatness.factor * maximum
intensity is set to 0.}
}
\value{
The jaggedness of a chromatographic peak (double)
}
\description{
Calculates the Jaggedness of the integrated region of a chromatographic peak. The Jaggedness is found by determining the fraction of
time points the intensity of the peak changes direction - excluding the peak apex and any intensity changes below a flatness factor.
}
\details{
This function repurposed from TargetedMSQC. Toghi Eshghi, S., Auger, P., & Mathews, W. R. (2018). Quality assessment and
interference detection in targeted mass spectrometry data using machine learning. Clinical Proteomics, 15.
https://doi.org/10.1186/s12014-018-9209-x
}
\examples{
# Calculate Jaggedness for a peak
data(ex_pts)
data(ex_peakData)
jaggedness <- calculateJaggedness(peakData = ex_peakData, pts = ex_pts)

}
