% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplePRCPlot.R
\name{multiplePRCPlot}
\alias{multiplePRCPlot}
\title{Generate a plot with multiple PRC curves}
\usage{
multiplePRCPlot(metaObject, filterObject, title = NULL,
  legend.names = NULL, curveColors = NULL, size = 22)
}
\arguments{
\item{metaObject}{a metaObject which must have \code{metaObject$originalData} populated with a list of \code{datasetObjects} that will be used for discovery}

\item{filterObject}{a metaFilter object containing the signature genes that will be used for calculating the score}

\item{title}{title of the plot}

\item{legend.names}{the name listed for each dataset in the legend (default: the \code{datasetObject$formattedName} for each dataset)}

\item{curveColors}{\emph{Graphical:} vector of colors for the PRC curves}

\item{size}{use this to easily increase or decrease the size of all the text in the plot}
}
\value{
Returns a ggplot PRC plot for all datasets
}
\description{
for each dataset in the metaObject, prcPlot will return a ggplot of a Precision-Recall curve (and return the AUPRC) that describes how well a gene signature
(as defined in a \code{filterObject}) classifies groups in a dataset (in the form of a \code{datasetObject}).
}
\details{
Each PRC plot evaluates the ability of a given gene set to separate two classes. As opposed to ROC curves, PRC curves are more sensitive to class imbalances.
The gene set is evaluated as a Z-score of the difference in means between the positive genes and the negative genes (see calculateScore).
}
\examples{
multiplePRCPlot(tinyMetaObject, filterObject = 
   tinyMetaObject$filterResults$pValueFDR0.05_es0_nStudies1_looaTRUE_hetero0)
}
\seealso{
\code{\link{prcPlot}}, \code{\link{multipleROCPlot}}
}
\author{
Aditya M. Rao, Andrew B. Liu
}
