% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lincsTools.R
\name{lincsCorrelate}
\alias{lincsCorrelate}
\title{Run Shane's LINCS Correlate on MetaIntegrator}
\usage{
lincsCorrelate(metaObject, filterObject, dataset = "CP",
  hit.number.hm = 20, direction = "reverse", cor.method = "pearson",
  drop.string = NULL, just_clin = F, show_clin = F, gene_ann = F)
}
\arguments{
\item{metaObject}{a Meta object which must have the $originalData populated}

\item{filterObject}{a MetaFilter object containing the signature genes that will be used for calculating the score}

\item{dataset}{The LINCS dataset to use. One of "CP" (drugs),"SH" (shRNA),"OE" (over-expression),
"LIG" (ligands),"MUT" (mutants) (default: CP)}

\item{hit.number.hm}{How many hits to show in a heatmap (default: 20)}

\item{direction}{one of "reverse", "aggravate", or "absolute" (default: "reverse") 
for whether you want to reverse the signature, aggravate it, or just want the top absolute hits.}

\item{cor.method}{method to use for correlation (pearson or spearman) (default: "pearson")}

\item{drop.string}{lets you include a string to drop drugs that contain a regular expression.
Useful for getting rid of screening hits.  
One useful option is "^BRD", which gets rid of all of the Broad screening hits that aren't characterized. (default: NULL)}

\item{just_clin}{only consider clinically relevant results (default: FALSE)}

\item{show_clin}{Generate a list of clinically relevant results (default: FALSE)}

\item{gene_ann}{whether to annotate genes (default: FALSE)}
}
\value{
The full list of correlations as well as the dataframe with the expression of the top hits.
Also generates the heatmap of the top hits.
}
\description{
Run Shane's LINCS Correlate on MetaIntegrator
}
\examples{
\dontrun{
####### DATA SETUP ##########
# Example won't work on tinyMetaObject because it requires real gene names
# Download the needed datasets for processing. 
sleData <- getGEOData(c("GSE11909","GSE50635", "GSE39088"))

#Label classes in the datasets
sleData$originalData$GSE50635 <- classFunction(sleData$originalData$GSE50635, 
  column = "subject type:ch1", diseaseTerms = c("Subject RBP +", "Subject RBP -"))
sleData$originalData$GSE11909_GPL96 <- classFunction(sleData$originalData$GSE11909_GPL96, 
   column = "Illness:ch1", diseaseTerms = c("SLE"))
sleData$originalData$GSE39088 <- classFunction(sleData$originalData$GSE39088, 
   column= "disease state:ch1", diseaseTerms=c("SLE"))
 #Remove the GPL97 platform that was downloaded
sleData$originalData$GSE11909_GPL97 <- NULL

#Run Meta-Analysis
sleMetaAnalysis <- runMetaAnalysis(sleData, runLeaveOneOutAnalysis = F, maxCores = 1)

#Filter genes
sleMetaAnalysis <- filterGenes(sleMetaAnalysis, isLeaveOneOut = F, 
   effectSizeThresh = 1, FDRThresh = 0.05)
####### END DATA SETUP ##########

 lincsCorrelate( metaObject = sleMetaAnalysis, filterObject = sleMetaAnalysis$filterResults[[1]], 
    dataset = "CP", direction = "reverse")
}
}
