% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{scrape_meta}
\alias{scrape_meta}
\title{Convert forest plot or summary table to meta-analytic dataset}
\usage{
scrape_meta(type = "RR", est, hi, sqrt = FALSE)
}
\arguments{
\item{type}{\code{RR} if point estimates are RRs or ORs (to be handled on log scale); \code{raw} if point estimates are raw differences, standardized mean differences, etc. (such that they can be handled with no transformations)}

\item{est}{Vector of study point estimates on RR or OR scale}

\item{hi}{Vector of upper bounds of 95\% CIs on RRs}

\item{sqrt}{Vector of booleans (TRUE/FALSE) for whether each study measured an odds ratio of a common outcome that should be approximated as a risk ratio via the square-root transformation}
}
\description{
Given relative risks (RR) and upper bounds of 95\% confidence intervals (CI)
from a forest plot or summary table, returns a dataframe ready for meta-analysis
(e.g., via the \code{metafor} package) with the log-RRs and their variances.
Optionally, the user may indicate studies for which the point estimate is to be
interpreted as an odds ratios of a common outcome rather than a relative risk;
for such studies, the function applies VanderWeele (2017)'s square-root transformation to convert
the odds ratio to an approximate risk ratio.
}
\references{
VanderWeele TJ (2017). On a square-root transformation of the odds ratio for a common outcome. \emph{Epidemiology}.
}
