% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryStatistics.R
\name{validate_tree}
\alias{validate_tree}
\title{Validate and Parse a Phylogenetic Tree}
\usage{
validate_tree(tree)
}
\arguments{
\item{tree}{A phylogenetic tree in Newick format (as a character string) or an object of class \code{phylo} from the \code{ape} package.
\itemize{
\item If the input is a character string, it must follow the Newick format (e.g., \code{"((tip_1:1,tip_2:1):5,tip_3:6);"}).
\item If an object of class \code{phylo} is provided, it should be a valid phylogenetic tree.
}}
}
\value{
A \code{phylo} object representing the validated and parsed tree.
}
\description{
This function checks whether the input is a valid phylogenetic tree, either as a character string in Newick format
or as an object of class \code{phylo} from the \code{ape} package. If the input is a Newick string, it is parsed into
a \code{phylo} object. The function also ensures that the tree contains at least two tips.
}
\details{
\itemize{
\item The function first verifies that the input is either a valid \code{phylo} object or a character string.
\item If the input is a Newick string, it attempts to parse it into a \code{phylo} object using \code{ape::read.tree()}.
\item If parsing fails, an informative error message is returned.
\item The function also checks that the tree contains at least two tips, as a valid phylogenetic tree should have at least one split.
}
}
