% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviance_tweedie.R
\name{deviance_tweedie}
\alias{deviance_tweedie}
\title{Tweedie deviance}
\usage{
deviance_tweedie(actual, predicted, w = NULL, tweedie_p = 0, ...)
}
\arguments{
\item{actual}{Observed values.}

\item{predicted}{Predicted values.}

\item{w}{Optional case weights.}

\item{tweedie_p}{Tweedie power.}

\item{...}{Further arguments passed to \code{weighted_mean}.}
}
\value{
A numeric vector of length one.
}
\description{
Weighted average of (unscaled) unit Tweedie deviance with parameter p. This includes the normal deviance (p = 0), the Poisson deviance (p = 1), as well as the Gamma deviance (p = 2), see e.g. [1] for a reference.
}
\examples{
deviance_tweedie(1:10, (1:10)^2, tweedie_p = 0)
deviance_tweedie(1:10, (1:10)^2, tweedie_p = 1)
deviance_tweedie(1:10, (1:10)^2, tweedie_p = 2)
deviance_tweedie(1:10, (1:10)^2, tweedie_p = 1.5)
deviance_tweedie(1:10, (1:10)^2, tweedie_p = 1.5, w = rep(1, 10))
deviance_tweedie(1:10, (1:10)^2, tweedie_p = 1.5, w = 1:10)

}
\references{
[1] Ohlsson E. and Johansson B. (2015). Non-Life Insurance Pricing with Generalized Linear Models. Springer Nature EN. ISBN 978-3642107900.
}
\seealso{
\code{\link{deviance_normal}, \link{deviance_poisson}, \link{deviance_gamma}}.
}
\author{
Michael Mayer, \email{mayermichael79@gmail.com}
}
