% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha_div_test.R
\name{hill_test_rarperm_pq}
\alias{hill_test_rarperm_pq}
\title{Test multiple times effect of factor on Hill diversity
with different rarefaction even depth}
\usage{
hill_test_rarperm_pq(
  physeq,
  fact,
  hill_scales = c(0, 1, 2),
  nperm = 99,
  sample.size = min(sample_sums(physeq)),
  verbose = FALSE,
  progress_bar = TRUE,
  p_val_signif = 0.05,
  type = "non-parametrique",
  ...
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{fact}{(required) Name of the factor in \code{physeq@sam_data} used to plot
different lines}

\item{hill_scales}{(a vector of integer) The list of q values to compute
the hill number H^q. If Null, no hill number are computed. Default value
compute the Hill number 0 (Species richness), the Hill number 1
(exponential of Shannon Index) and the Hill number 2 (inverse of Simpson
Index).}

\item{nperm}{(int) The number of permutations to perform.}

\item{sample.size}{(int) A single integer value equal to the number of
reads being simulated, also known as the depth. See
\code{\link[phyloseq:rarefy_even_depth]{phyloseq::rarefy_even_depth()}}.}

\item{verbose}{(logical). If TRUE, print additional informations.}

\item{progress_bar}{(logical, default TRUE) Do we print progress during
the calculation?}

\item{p_val_signif}{(float, \verb{[0:1]}) The mimimum value of p-value to count a
test as significant int the \code{prop_signif} result.}

\item{type}{A character specifying the type of statistical approach
(See \code{\link[ggstatsplot:ggbetweenstats]{ggstatsplot::ggbetweenstats()}} for more details):
\itemize{
\item "parametric"
\item "nonparametric"
\item "robust"
\item "bayes"
}}

\item{...}{Other arguments passed on to \code{\link[ggstatsplot:ggbetweenstats]{ggstatsplot::ggbetweenstats()}} function}
}
\value{
A list of 6 components :
\itemize{
\item method
\item expressions
\item plots
\item pvals
\item prop_signif
\item statistics
}
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


This reduce the risk of a random drawing of a exceptional situation of an unique rarefaction.
}
\examples{
\donttest{
if (requireNamespace("ggstatsplot")) {
  hill_test_rarperm_pq(data_fungi, "Time", nperm = 2)
  res <- hill_test_rarperm_pq(data_fungi, "Height", nperm = 9, p.val = 0.9)
  patchwork::wrap_plots(res$plots[[1]])
  res$plots[[1]][[1]] + res$plots[[2]][[1]] + res$plots[[3]][[1]]
  res$prop_signif
  res_para <- hill_test_rarperm_pq(data_fungi, "Height", nperm = 9, type = "parametrique")
  res_para$plots[[1]][[1]] + res_para$plots[[2]][[1]] + res_para$plots[[3]][[1]]
  res_para$pvals
  res_para$method
  res_para$expressions[[1]]
}
}
}
\seealso{
\code{\link[ggstatsplot:ggbetweenstats]{ggstatsplot::ggbetweenstats()}}, \code{\link[=hill_pq]{hill_pq()}}
}
\author{
Adrien Taudière
}
